/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.io.util.DateTimeUtil;
import cfca.sadk.com.itextpdf.signatures.CrlClientOnline;
import cfca.sadk.com.itextpdf.signatures.SignUtils;
import cfca.sadk.com.itextpdf.signatures.VerificationException;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateVerification {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrlClientOnline.class);

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls) {
        return CertificateVerification.verifyCertificate(cert, crls, DateTimeUtil.getCurrentTimeCalendar());
    }

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (SignUtils.hasUnsupportedCriticalExtension(cert)) {
            return "Has unsupported critical extension";
        }
        try {
            cert.checkValidity(calendar.getTime());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (crls != null) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls) {
        return CertificateVerification.verifyCertificates(certs, keystore, crls, DateTimeUtil.getCurrentTimeCalendar());
    }

    /*
     * Loose catch block
     */
    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls, Calendar calendar) {
        ArrayList<VerificationException> result = new ArrayList<VerificationException>();
        for (int k = 0; k < certs.length; ++k) {
            int j;
            X509Certificate cert = (X509Certificate)certs[k];
            String err = CertificateVerification.verifyCertificate(cert, crls, calendar);
            if (err != null) {
                result.add(new VerificationException(cert, err));
            }
            try {
                for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                    if (CertificateVerification.verifyCertificate(certStoreX509, crls, calendar) != null) continue;
                    {
                        catch (Exception exception) {}
                    }
                    try {
                        cert.verify(certStoreX509.getPublicKey());
                        return result;
                    }
                    catch (Exception e) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (j = 0; j < certs.length; ++j) {
                if (j == k) continue;
                X509Certificate certNext = (X509Certificate)certs[j];
                try {
                    cert.verify(certNext.getPublicKey());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (j != certs.length) continue;
            result.add(new VerificationException(cert, "Cannot be verified against the KeyStore or the certificate chain"));
        }
        if (result.size() == 0) {
            result.add(new VerificationException((Certificate)null, "Invalid state. Possible circular certificate chain"));
        }
        return result;
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore) {
        return CertificateVerification.verifyCertificates(certs, keystore, DateTimeUtil.getCurrentTimeCalendar());
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Calendar calendar) {
        return CertificateVerification.verifyCertificates(certs, keystore, null, calendar);
    }

    public static boolean verifyOcspCertificates(BasicOCSPResp ocsp, KeyStore keystore, String provider) {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        try {
            for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                try {
                    return SignUtils.isSignatureValid(ocsp, (Certificate)certStoreX509, provider);
                }
                catch (Exception ex) {
                    exceptionsThrown.add(ex);
                }
            }
        }
        catch (Exception e) {
            exceptionsThrown.add(e);
        }
        for (Exception ex : exceptionsThrown) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public static boolean verifyTimestampCertificates(TimeStampToken ts, KeyStore keystore, String provider) {
        ArrayList<Exception> exceptionsThrown = new ArrayList<Exception>();
        try {
            for (X509Certificate certStoreX509 : SignUtils.getCertificates(keystore)) {
                try {
                    SignUtils.isSignatureValid(ts, certStoreX509, provider);
                    return true;
                }
                catch (Exception ex) {
                    exceptionsThrown.add(ex);
                }
            }
        }
        catch (Exception e) {
            exceptionsThrown.add(e);
        }
        for (Exception ex : exceptionsThrown) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }
}

