/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource.UriEncodeUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class UriResolver {
    private URL baseUrl;
    private boolean isLocalBaseUri;

    public UriResolver(String baseUri) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri");
        }
        this.resolveBaseUrlOrPath(baseUri);
    }

    public String getBaseUri() {
        return this.baseUrl.toExternalForm();
    }

    public URL resolveAgainstBaseUri(String uriString) throws MalformedURLException {
        URL resolvedUrl = null;
        uriString = uriString.trim();
        uriString = UriEncodeUtil.encode(uriString);
        if (this.isLocalBaseUri && !uriString.startsWith("file:")) {
            try {
                File file = new File(uriString);
                if (file.isAbsolute()) {
                    resolvedUrl = file.toURI().toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resolvedUrl == null) {
            resolvedUrl = new URL(this.baseUrl, uriString);
        }
        return resolvedUrl;
    }

    public boolean isLocalBaseUri() {
        return this.isLocalBaseUri;
    }

    private void resolveBaseUrlOrPath(String base) {
        base = base.trim();
        this.baseUrl = this.baseUriAsUrl(UriEncodeUtil.encode(base));
        if (this.baseUrl == null) {
            this.baseUrl = this.uriAsFileUrl(base);
        }
        if (this.baseUrl == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format("Invalid base URI: {0}", base));
        }
    }

    private URL baseUriAsUrl(String baseUriString) {
        URL baseAsUrl = null;
        try {
            URI baseUri = new URI(baseUriString);
            if (baseUri.isAbsolute()) {
                baseAsUrl = baseUri.toURL();
                if ("file".equals(baseUri.getScheme())) {
                    this.isLocalBaseUri = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsUrl;
    }

    private URL uriAsFileUrl(String baseUriString) {
        URL baseAsFileUrl = null;
        try {
            File file = new File(baseUriString);
            if (this.isFileRooted(file, baseUriString)) {
                String str = "file:///" + this.encode(file, file.getAbsolutePath());
                baseAsFileUrl = new URI(str).toURL();
            } else {
                String str = this.encode(file, baseUriString);
                URL base = new File("").toURI().toURL();
                baseAsFileUrl = new URL(base, str);
            }
            this.isLocalBaseUri = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsFileUrl;
    }

    private String encode(File file, String str) {
        str = str.replace("\\", "/");
        str = UriEncodeUtil.encode(str);
        if (file.isDirectory() && !str.endsWith("/")) {
            str = str + "/";
        }
        str = str.replaceFirst("/*\\\\*", "");
        return str;
    }

    private boolean isFileRooted(File file, String str) {
        return file.isAbsolute() || str.startsWith("/");
    }
}

