/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CoordinateUtil;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ContentUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FontUtil.class);

    public static void addTextToPdf(byte[] pdfData, OutputStream outputStream, List<TextAppearance> appearanceList) throws SealException, IOException {
        ContentUtil.addTextToPdf(new PdfReader(pdfData), outputStream, appearanceList);
    }

    public static void addImageToPdf(byte[] pdfData, OutputStream outputStream, List<GraphicAppearance> appearanceList) throws SealException, IOException {
        ContentUtil.addImageToPdf(new PdfReader(pdfData), outputStream, appearanceList, false);
    }

    public static void addImageToPdf(byte[] pdfData, OutputStream outputStream, List<GraphicAppearance> appearanceList, boolean isSameImage) throws SealException, IOException {
        ContentUtil.addImageToPdf(new PdfReader(pdfData), outputStream, appearanceList, isSameImage);
    }

    public static void addTextToPdf(InputStream inputStream, OutputStream outputStream, List<TextAppearance> appearanceList) throws SealException, IOException {
        ContentUtil.addTextToPdf(new PdfReader(inputStream), outputStream, appearanceList);
    }

    public static void addImageToPdf(InputStream inputStream, OutputStream outputStream, List<GraphicAppearance> appearanceList) throws SealException, IOException {
        ContentUtil.addImageToPdf(new PdfReader(inputStream), outputStream, appearanceList, false);
    }

    private static void addTextToPdf(PdfReader reader, OutputStream outputStream, List<TextAppearance> appearanceList) throws SealException {
        block16: {
            businessLog.info("addTextToPdf begin...");
            Document document = null;
            try {
                PdfDocument pdfDocument = new PdfDocument(reader, new PdfWriter(outputStream), new StampingProperties(), false);
                ParamsCheckUtil.checkSignature(pdfDocument);
                document = new Document(pdfDocument);
                if (null == appearanceList) break block16;
                for (int i = 0; i < appearanceList.size(); ++i) {
                    TextAppearance appearance = appearanceList.get(i);
                    String text = appearance.getSignText();
                    Color color = appearance.getFontColor();
                    float fontSize = appearance.getFontSize();
                    int pageNum = appearance.getPageNum();
                    Rectangle rect = appearance.getRectangle();
                    ParamsCheckUtil.checkFontSize(fontSize, text, rect);
                    PdfPage currentPage = pdfDocument.getPage(pageNum);
                    PageSize currentPageSize = new PageSize(currentPage.getPageSize());
                    Rectangle mediaBox = currentPage.getMediaBox();
                    if (appearance.isUpperLeftCoordinate() && rect.getY() >= 0.0f) {
                        rect = CoordinateUtil.convert(currentPageSize, rect);
                    }
                    if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                        rect = new Rectangle(rect.getX() + mediaBox.getX(), rect.getY() + mediaBox.getY(), rect.getWidth(), rect.getHeight());
                    }
                    PdfExtGState gs1 = new PdfExtGState();
                    gs1.setFillOpacity(appearance.getTransparency());
                    Paragraph paragraph = new Paragraph(text);
                    PdfFont pdfFont = appearance.getFont();
                    if (PDFUtil.containsUCS4Glyph(text)) {
                        try {
                            pdfFont = UCS4FontUtil.getInstance().subsetFont(text);
                        }
                        catch (SealException e) {
                            businessLog.error("UCS4FontUtil.subsetFont failed", (Throwable)e);
                        }
                    }
                    if (null == pdfFont) {
                        try {
                            pdfFont = FontUtil.getInstance().subsetFont(text);
                        }
                        catch (SealException e) {
                            businessLog.error("FontUtil.subsetFont failed", (Throwable)e);
                        }
                    }
                    ((Paragraph)((Paragraph)paragraph.setFont(pdfFont)).setFontColor(color)).setFontSize(fontSize);
                    PdfCanvas pdfCanvas = new PdfCanvas(currentPage);
                    pdfCanvas.saveState();
                    pdfCanvas.setExtGState(gs1);
                    Rectangle docRect = CoordinateUtil.rectangleToTransformedCoordinate(currentPage, rect);
                    document.showTextAligned(paragraph, docRect.getX(), docRect.getY(), pageNum, TextAlignment.LEFT, VerticalAlignment.BOTTOM, 0.0f);
                    pdfCanvas.restoreState();
                }
            }
            catch (SealException e) {
                businessLog.error("addTextToPdf failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                businessLog.error("addTextToPdf failed", (Throwable)e);
                throw new SealException("addTextToPdf failed", e);
            }
            finally {
                if (null != document) {
                    document.close();
                }
                businessLog.info("addTextToPdf end...");
            }
        }
    }

    private static void addImageToPdf(PdfReader reader, OutputStream outputStream, List<GraphicAppearance> appearanceList, boolean isSameImage) throws SealException {
        businessLog.info("addImageToPdf begin...");
        Document document = null;
        PdfImageXObject imageXObject = null;
        PdfName pdfName = null;
        try {
            PdfDocument pdfDocument = new PdfDocument(reader, new PdfWriter(outputStream), new StampingProperties(), false);
            ParamsCheckUtil.checkSignature(pdfDocument);
            document = new Document(pdfDocument);
            if (null != appearanceList) {
                for (int i = 0; i < appearanceList.size(); ++i) {
                    GraphicAppearance appearance = appearanceList.get(i);
                    int pageNum = appearance.getPageNum();
                    Rectangle rect = appearance.getRectangle();
                    PdfPage currentPage = pdfDocument.getPage(pageNum);
                    PageSize currentPageSize = new PageSize(currentPage.getPageSize());
                    Rectangle mediaBox = currentPage.getMediaBox();
                    if (appearance.isUpperLeftCoordinate() && rect.getY() >= 0.0f) {
                        rect = CoordinateUtil.convert(currentPageSize, rect);
                    }
                    if (mediaBox.getX() != 0.0f || mediaBox.getY() != 0.0f) {
                        rect = new Rectangle(rect.getX() + mediaBox.getX(), rect.getY() + mediaBox.getY(), rect.getWidth(), rect.getHeight());
                    }
                    ImageData imageData = appearance.getImageData();
                    if (isSameImage && null == imageXObject) {
                        imageXObject = new PdfImageXObject(imageData);
                    }
                    PdfExtGState gs1 = new PdfExtGState();
                    gs1.setFillOpacity(appearance.getTransparency());
                    PdfPage pdfPage = pdfDocument.getPage(pageNum);
                    PdfCanvas pdfCanvas = new PdfCanvas(pdfPage);
                    pdfCanvas.saveState();
                    pdfCanvas.setExtGState(gs1);
                    Rectangle docRect = CoordinateUtil.rectangleToTransformedCoordinate(pdfPage, rect);
                    if (isSameImage) {
                        pdfName = pdfCanvas.addImage(imageXObject, docRect.getWidth(), 0.0f, 0.0f, docRect.getHeight(), docRect.getX(), docRect.getY(), pdfName);
                    } else {
                        pdfCanvas.addImage(imageData, docRect, false);
                    }
                    pdfCanvas.restoreState();
                }
            }
        }
        catch (SealException e) {
            businessLog.error("addTextToPdf failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addImageToPdf failed", (Throwable)e);
            throw new SealException("addImageToPdf failed", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
            businessLog.info("addImageToPdf end...");
        }
    }
}

