/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.crypto.BadPasswordException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.WriterProperties;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import java.io.InputStream;
import java.io.OutputStream;

public class EncryptUtil {
    private static Logger businessLog = LoggerFactory.getLogger(EncryptUtil.class);
    private static int encryptionType = 2;
    private static int permissions = 512;

    public static void encrypt(InputStream sourceStream, byte[] userPassword, OutputStream outputStream) throws SealException {
        PdfDocument document = null;
        businessLog.info("encrypt pdf begin...");
        if (null == sourceStream) {
            throw new IllegalArgumentException("sourceStream is null");
        }
        long start = System.currentTimeMillis();
        try {
            PdfReader reader = new PdfReader(sourceStream);
            PdfWriter writer = new PdfWriter(outputStream, new WriterProperties().setStandardEncryption(userPassword, userPassword, permissions, encryptionType).addXmpMetadata());
            document = new PdfDocument(reader, writer);
            ParamsCheckUtil.checkSignature(document);
        }
        catch (BadPasswordException e) {
            businessLog.error("the pdf file has set userPassword", (Throwable)e);
            throw new SealException("the pdf file has set userPassword");
        }
        catch (SealException e) {
            businessLog.error("encrypt pdf file,set userPassword failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("encrypt pdf file,set userPassword failed", (Throwable)e);
            throw new SealException("encrypt pdf file,set userPassword failed", e);
        }
        finally {
            if (document != null) {
                document.close();
            }
            long end = System.currentTimeMillis();
            businessLog.info("encrypt pdf end...cost=" + (end - start) + " ms");
        }
    }
}

