/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;

public final class SM2CardLoggings {
    private SM2CardLoggings() {
    }

    static String buildPrivateKeySignByHashFailedMessage(SM2CardKey sm2Key, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (sm2Key != null && sm2Key.isInternalKey()) {
            builder.append("SM2Card cardPrivateKeySignByHash");
        } else {
            builder.append("SM2Card cardPrivateKeySignByHash");
        }
        builder.append(" failure: ");
        if (sm2Key != null) {
            builder.append(",keyIndex: ").append(sm2Key.getKeyIndex());
            builder.append(",params: ").append(sm2Key.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        return builder.toString();
    }

    static String buildPublicKeyVerifyByHashFailedMessage(SM2CardKey sm2Key, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (sm2Key != null && sm2Key.isInternalKey()) {
            builder.append("SM2Card cardPublicKeyVerifyByHash");
        } else {
            builder.append("SM2Card cardPublicKeyVerifyByHash");
        }
        builder.append(" failure: ");
        if (sm2Key != null) {
            builder.append(",keyIndex: ").append(sm2Key.getKeyIndex());
            builder.append(",params: ").append(sm2Key.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        return builder.toString();
    }

    static StringBuilder buildKeyPairCheckFailed(StringBuilder builder, KeyPair keyPair) {
        if (keyPair != null) {
            builder.append("\nPrivateKey: ").append(keyPair.getPrivate());
            builder.append("\nPublicKey: ").append(keyPair.getPublic());
        } else {
            builder.append("\nkeyPair=null");
        }
        return builder;
    }

    static void warningGenerateKeyPairFailed(boolean isExport, int bitLength, int keyIndex, int keyUsage, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card generateKeyPair failure: ");
            builder.append("isExport=").append(isExport);
            builder.append(", bitLength=").append(bitLength);
            builder.append(", keyIndex=").append(isExport);
            builder.append(" , keyUsage=").append(keyUsage);
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static void warningSignByHashFailed(SM2CardKey sm2Key, byte[] sm3HashValue, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card signByHash failure: ");
            builder.append(" sm2Key=").append(sm2Key);
            builder.append(", sm3HashValue=").append(sm3HashValue == null ? "" : DataHelper.dump4KPartData(sm3HashValue));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static void warningVerifyByHashFailed(SM2CardKey sm2Key, byte[] sm3HashValue, byte[] sm2SignValue, int returnResult) {
        if (LoggerManager.exceptionLogger.isWarnEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card verifyByHash failure: ");
            builder.append(" sm2Key=").append(sm2Key);
            builder.append(", sm3HashValue=").append(DataHelper.dump4KPartData(sm3HashValue));
            builder.append(", sm2SignValue=").append(DataHelper.dump4KPartData(sm2SignValue));
            builder.append(", returnResult=").append(NumberHelper.hex(returnResult));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.warn(warning);
        }
    }

    static void warningVerifyByHashFailed(SM2CardKey sm2Key, byte[] sm3HashValue, byte[] sm2SignValue, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card verifyByHash failure: ");
            builder.append(" sm2Key=").append(sm2Key);
            builder.append(", sm3HashValue=").append(DataHelper.dump4KPartData(sm3HashValue));
            builder.append(", sm2SignValue=").append(DataHelper.dump4KPartData(sm2SignValue));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static void warningEncryptFailed(SM2CardKey sm2Key, byte[] sourceData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card [PublicKeyOperation]encrypt failure: ");
            builder.append(" sm2Key=").append(sm2Key);
            builder.append(", sourceData=").append(sourceData == null ? "" : DataHelper.dump4KPartData(sourceData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static void warninDecryptFailed(SM2CardKey sm2Key, byte[] encryptData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("SM2Card [PrivateKeyOperation]decrypt failure: ");
            builder.append(" sm2Key=").append(sm2Key);
            builder.append(", encryptData=").append(encryptData == null ? "" : DataHelper.dump4KPartData(encryptData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }
}

