/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.cavium;

import caviumcryptokit.jni.JNIInit;
import caviumcryptokit.jni.JNIRSA;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardOperationException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.IRSACard;
import cfca.sadk.lib.crypto.card.cavium.CaviumRSAPrivateKey;
import cfca.sadk.lib.crypto.card.cavium.CaviumRSAPublicKey;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class CaviumRSACard
implements IRSACard {
    public void initLib(Object param) throws CardException {
        JNIInit.initApplication();
    }

    public KeyPair generateKeyPair(boolean isExport, int bitLength, int keyIndex, int keyUsage) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug(String.format("RSAGenerateKeyPair>>>>>>Running: isExport=%s,bitLength=%s,keyIndex=%s,keyUsage=%s", isExport, bitLength, keyIndex, keyUsage));
        }
        try {
            KeyPair keypair = cfca.sadk.lib.crypto.jni.JNIRSA.RSAGenerateKeyPair(bitLength);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAGenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            KeyPair output = new KeyPair(new CaviumRSAPublicKey((RSAPublicKey)keypair.getPublic()), new CaviumRSAPrivateKey((RSAPrivateKey)keypair.getPrivate()));
            return output;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", (Throwable)e);
            throw new CardException("RSAGenerateKeyPair failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new CardException("RSAGenerateKeyPair failure: " + e.getMessage(), e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] digestInfoBytes) throws CardException {
        boolean operationResult;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSASignByHash>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n digestInfoBytes: ");
            buffer.append(SADKDebugger.dump(digestInfoBytes));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        CaviumRSAPrivateKey caviumPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = caviumPrivateKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CardParameterException("missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CardParameterException("RSASignByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(digestInfoBytes));
        }
        if (digestInfoBytes.length > moduleLength - 11) {
            throw new CardParameterException("RSASignByHash<<<<<<invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + (moduleLength - 11));
        }
        byte[] signData = new byte[caviumPrivateKey.moduleBytesLength];
        try {
            operationResult = JNIRSA.privateEncrypt((byte[])digestInfoBytes, (int)digestInfoBytes.length, (byte[])caviumPrivateKey.jniEncodedBytes, (byte[])signData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSASignByHash<<<<<<operation Failure", (Throwable)e);
            throw new CardOperationException("RSASignByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSASignByHash<<<<<<operation Failure", e);
            throw new CardOperationException("RSASignByHash<<<<<<operation failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSASignByHash<<<<<<operation failure: operationResult=" + operationResult);
            throw new CardException("RSASignByHash<<<<<<operation failure: operationResult=" + operationResult);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSASignByHash<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] digestInfoBytes, byte[] signData) throws CardException {
        int returnValue;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAVerifyByHash>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n digestInfoBytes: ");
            buffer.append(SADKDebugger.dump(digestInfoBytes));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        CaviumRSAPublicKey caviumPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = caviumPublicKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(digestInfoBytes));
        }
        if (digestInfoBytes.length > moduleLength - 11) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + (moduleLength - 11));
        }
        if (signData == null || signData.length == 0) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<missing signedData");
        }
        if (signData.length != moduleLength) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid signedLength: " + signData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            returnValue = JNIRSA.publicDecrypt((byte[])signData, (byte[])caviumPublicKey.jniEncodedBytes, (byte[])decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAVerifyByHash<<<<<<operation failure", (Throwable)e);
            throw new CardOperationException("RSAVerifyByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAVerifyByHash<<<<<<operation failure", e);
            throw new CardOperationException("RSAVerifyByHash<<<<<<operation failure", e);
        }
        if (returnValue < 0 || returnValue > moduleLength) {
            LoggerManager.exceptionLogger.error("RSAVerifyByHash<<<<<<operation failure: returnValue=" + returnValue);
            throw new CardException("RSAVerifyByHash<<<<<<operation failure: returnValue=" + returnValue);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAVerifyByHash<<<<<<hashValue=" + SADKDebugger.dump(digestInfoBytes));
            LoggerManager.debugLogger.debug("RSAVerifyByHash<<<<<<decryptData=" + SADKDebugger.dump(decryptData));
        }
        byte[] outBytes = cfca.sadk.org.bouncycastle.util.Arrays.copyOf(decryptData, returnValue);
        boolean verifyResult = Arrays.equals(digestInfoBytes, outBytes);
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAVerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        boolean operationResult;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSAEncrypt>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        CaviumRSAPublicKey caviumPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = caviumPublicKey.moduleBytesLength;
        if (sourceData == null || sourceData.length == 0) {
            throw new CardParameterException("RSAEncrypt<<<<<<missing sourceData");
        }
        if (sourceData.length > moduleLength - 11) {
            throw new CardParameterException("RSAEncrypt<<<<<<invalid sourceLength: " + sourceData.length + ",limitLength=" + (moduleLength - 11));
        }
        byte[] encryptData = new byte[moduleLength];
        try {
            operationResult = JNIRSA.publicEncrypt((byte[])sourceData, (int)sourceData.length, (byte[])caviumPublicKey.jniEncodedBytes, (byte[])encryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSAEncrypt<<<<<<operation failure", (Throwable)e);
            throw new CardOperationException("RSAEncrypt<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAEncrypt<<<<<<operation failure", e);
            throw new CardOperationException("RSAEncrypt<<<<<<operation failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSAEncrypt<<<<<<operation failure: operationResult=" + operationResult);
            throw new CardException("RSAEncrypt<<<<<<operation failure: operationResult=" + operationResult);
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CardException {
        int returnValue;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RSADecrypt>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        CaviumRSAPrivateKey caviumPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = caviumPrivateKey.moduleBytesLength;
        if (encryptData == null || encryptData.length == 0) {
            throw new CardParameterException("RSADecrypt<<<<<<missing encryptData");
        }
        if (encryptData.length != moduleLength) {
            throw new CardParameterException("RSADecrypt<<<<<<invalid encryptLength: " + encryptData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            returnValue = JNIRSA.privateDecrypt((byte[])encryptData, (byte[])caviumPrivateKey.jniEncodedBytes, (byte[])decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSADecrypt<<<<<<operation failure", (Throwable)e);
            throw new CardOperationException("RSADecrypt<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSADecrypt<<<<<<operation failure", e);
            throw new CardOperationException("RSADecrypt<<<<<<operation failure", e);
        }
        if (returnValue < 0 || returnValue > moduleLength) {
            LoggerManager.exceptionLogger.error("RSADecrypt<<<<<<operation failure: returnValue=" + returnValue);
            throw new CardException("RSADecrypt<<<<<<operation failure: returnValue=" + returnValue);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSADecrypt<<<<<<returnValue=" + returnValue);
            LoggerManager.debugLogger.debug("RSADecrypt<<<<<<decryptData=" + SADKDebugger.dump(decryptData));
        }
        byte[] outBytes = cfca.sadk.org.bouncycastle.util.Arrays.copyOf(decryptData, returnValue);
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSADecrypt<<<<<<Finished: decryptData=" + SADKDebugger.dump(outBytes));
        }
        return outBytes;
    }

    private CaviumRSAPrivateKey convertPrivateKey(PrivateKey privateKey) throws CardException {
        if (privateKey == null) {
            throw new CardParameterException("missing privateKey");
        }
        CaviumRSAPrivateKey outputPrivateKey = null;
        if (privateKey instanceof CaviumRSAPrivateKey) {
            outputPrivateKey = (CaviumRSAPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateKey) {
            outputPrivateKey = new CaviumRSAPrivateKey((RSAPrivateKey)privateKey);
        } else {
            throw new CardParameterException("invalid privateKey(required RSAPrivateKey)");
        }
        return outputPrivateKey;
    }

    private CaviumRSAPublicKey convertPublicKey(PublicKey publicKey) throws CardException {
        if (publicKey == null) {
            throw new CardParameterException("missing publicKey");
        }
        CaviumRSAPublicKey outputPublicKey = null;
        if (publicKey instanceof CaviumRSAPublicKey) {
            outputPublicKey = (CaviumRSAPublicKey)publicKey;
        } else if (publicKey instanceof RSAPublicKey) {
            outputPublicKey = new CaviumRSAPublicKey((RSAPublicKey)publicKey);
        } else {
            throw new CardParameterException("invalid publicKey(required RSAPublicKey)");
        }
        return outputPublicKey;
    }

    public void unInitLib(Object param) {
        JNIInit.unInitApplication();
    }

    public boolean checkIdleTest() throws CardException {
        return true;
    }
}

