/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.signer;

import cfca.sadk.lib.crypto.hard.format.HashLengths;
import cfca.sadk.lib.crypto.hard.format.SM2Decide;
import cfca.sadk.lib.crypto.hard.format.SM2Format;
import cfca.sadk.lib.crypto.hard.format.SM2FormatKey;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import cfca.sadk.lib.crypto.hard.signer.AbsSigner;
import cfca.sadk.system.logging.LoggerManager;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;

public final class SM2Signer
extends AbsSigner {
    private static String signByHashName;

    protected SM2Signer(Provider provider, String mType, boolean asn1Format) throws Exception {
        super(provider, mType, asn1Format);
        if (signByHashName == null) {
            signByHashName = SM2Decide.getSignByHashName(provider);
            LoggerManager.systemLogger.info("SM2SignByHashName: " + signByHashName);
        }
    }

    PrivateKey formatPrivateKey(PrivateKey privateKey) throws Exception {
        PrivateKey jceKey = null;
        jceKey = privateKey instanceof InternalPrivateKey ? ((InternalPrivateKey)privateKey).getInternalPrivateKey() : SM2FormatKey.convertToProviderSM2PrivateKey(this.provider, privateKey);
        return jceKey;
    }

    PublicKey formatPublicKey(PublicKey publicKey) throws Exception {
        return SM2FormatKey.convertToProviderSM2PublicKey(this.provider, publicKey);
    }

    byte[] formatInputSignValue(byte[] input) throws Exception {
        return SM2Format.signedInFormat(this.mType, input, this.asn1Format);
    }

    byte[] formatOutputSignValue(byte[] output) throws Exception {
        return SM2Format.signedOutFormat(this.mType, output);
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Signature signature = Signature.getInstance(signByHashName, this.provider);
        signature.initSign(this.formatPrivateKey(privateKey));
        signature.update(hashValue);
        byte[] signData = signature.sign();
        return this.formatOutputSignValue(signData);
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signData) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Signature signature = Signature.getInstance(signByHashName, this.provider);
        signature.initVerify(this.formatPublicKey(publicKey));
        signature.update(hashValue);
        return signature.verify(this.formatInputSignValue(signData));
    }

    public int setEccLength(PrivateKey privateKey) throws Exception {
        return 32;
    }
}

