/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNIHash;

public final class JNIDigest
implements Digest {
    public static final int NID_md5 = 4;
    public static final int NID_sha1 = 64;
    public static final int NID_sha256 = 672;
    public static final int NID_sha384 = 673;
    public static final int NID_sha512 = 674;
    public static final int NID_ChinaSM3 = 922;
    private final JNIHash jniHash;
    private final String algorithmName;
    private final int digestSize;
    private final int hashID;

    public JNIDigest(int hashID) throws PKIException {
        JNIHash jniHash;
        String name;
        int size;
        switch (hashID) {
            case 4: {
                size = 16;
                name = "MD5";
                break;
            }
            case 64: {
                size = 20;
                name = "SHA-1";
                break;
            }
            case 672: {
                size = 32;
                name = "SHA-256";
                break;
            }
            case 673: {
                size = 48;
                name = "SHA-384";
                break;
            }
            case 674: {
                size = 64;
                name = "SHA-512";
                break;
            }
            case 922: {
                size = 32;
                name = "SM3";
                break;
            }
            default: {
                throw new PKIException("JNIHash invalid hashID=" + hashID);
            }
        }
        try {
            jniHash = new JNIHash();
            jniHash.init(hashID);
            LoggerManager.systemLogger.info("jniHash-->init({})", (Object)hashID);
        }
        catch (Exception e) {
            throw new PKIException("JNIHash init failed: hashID=" + hashID, e);
        }
        catch (Throwable e) {
            throw new PKIException("JNIHash init failed: hashID=" + hashID, e);
        }
        this.jniHash = jniHash;
        this.digestSize = size;
        this.algorithmName = name;
        this.hashID = hashID;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getDigestSize() {
        return this.digestSize;
    }

    public void update(byte in) {
        this.update(new byte[]{in});
    }

    public void update(byte[] in, int inOff, int len) {
        if (in == null) {
            throw new SecurityException("JNIHash update failed: required in not null");
        }
        if (inOff < 0) {
            throw new SecurityException("JNIHash update failed: required inOff>=0");
        }
        if (len < 0) {
            throw new SecurityException("JNIHash update failed: required len>=0");
        }
        if (in.length - inOff < len) {
            throw new SecurityException("JNIHash update failed: required in.length-inOff>=len=" + len);
        }
        if (len > 0) {
            byte[] data = new byte[len];
            System.arraycopy(in, inOff, data, 0, data.length);
            this.update(data);
        }
    }

    public void update(byte[] in) {
        if (in != null) {
            try {
                this.jniHash.update(in);
            }
            catch (Exception e) {
                throw new SecurityException("JNIHash update failed", e);
            }
            catch (Throwable e) {
                throw new SecurityException("JNIHash update failed", e);
            }
        }
    }

    public int doFinal(byte[] out, int outOff) {
        if (out == null) {
            throw new SecurityException("JNIHash doFinal failed: required out not null");
        }
        if (outOff < 0) {
            throw new SecurityException("JNIHash doFinal failed: required outOff>=0");
        }
        if (out.length - outOff < this.digestSize) {
            throw new SecurityException("JNIHash update failed: required out.length-outOff>=digestSize=" + this.digestSize);
        }
        byte[] hash = new byte[this.digestSize];
        try {
            LoggerManager.systemLogger.info("jniHash-->doFinal({})", (Object)this.hashID);
            this.jniHash.doFinal(hash);
        }
        catch (Exception e) {
            throw new SecurityException("JNIHash doFinal failed", e);
        }
        catch (Throwable e) {
            throw new SecurityException("JNIHash doFinal failed", e);
        }
        System.arraycopy(hash, 0, out, outOff, hash.length);
        return hash.length;
    }

    public void reset() {
        try {
            LoggerManager.systemLogger.info("jniHash-->init(reset)");
            this.jniHash.init(this.hashID);
        }
        catch (Exception e) {
            throw new SecurityException("JNIHash init failed: hashID=" + this.hashID, e);
        }
        catch (Throwable e) {
            throw new SecurityException("JNIHash init failed: hashID=" + this.hashID, e);
        }
    }

    public static void destroy(Digest jniHash) {
        boolean required;
        boolean bl = required = jniHash != null && jniHash instanceof JNIDigest;
        if (required) {
            LoggerManager.systemLogger.info("jniHash destroy...");
            try {
                byte[] outData = new byte[jniHash.getDigestSize()];
                LoggerManager.systemLogger.info("jniHash-->doFinal(destroy)");
                ((JNIDigest)jniHash).doFinal(outData, 0);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.warn("jniHash destroy failed", (Throwable)e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.warn("jniHash destroy failed", e);
            }
        }
    }
}

