/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.prng;

import cfca.sadk.org.bouncycastle.crypto.prng.DRBGProvider;
import cfca.sadk.org.bouncycastle.crypto.prng.EntropySource;
import cfca.sadk.org.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import java.security.SecureRandom;

public class SP800SecureRandom
extends SecureRandom {
    private static final long serialVersionUID = -1064140569918805490L;
    private final DRBGProvider drbgProvider;
    private final boolean predictionResistant;
    private final SecureRandom randomSource;
    private final EntropySource entropySource;
    private SP80090DRBG drbg;

    SP800SecureRandom(SecureRandom randomSource, EntropySource entropySource, DRBGProvider drbgProvider, boolean predictionResistant) {
        this.randomSource = randomSource;
        this.entropySource = entropySource;
        this.drbgProvider = drbgProvider;
        this.predictionResistant = predictionResistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(byte[] seed) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(seed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long seed) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(seed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] bytes) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            if (this.drbg == null) {
                this.drbg = this.drbgProvider.get(this.entropySource);
            }
            if (this.drbg.generate(bytes, null, this.predictionResistant) < 0) {
                this.drbg.reseed(this.entropySource.getEntropy());
                this.drbg.generate(bytes, null, this.predictionResistant);
            }
        }
    }

    public byte[] generateSeed(int numBytes) {
        byte[] bytes = new byte[numBytes];
        this.nextBytes(bytes);
        return bytes;
    }
}

