/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider;

import cfca.sadk.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import cfca.sadk.org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import javax.crypto.spec.DHParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;

    BouncyCastleProviderConfiguration() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setParameter(String parameterName, Object parameter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (parameterName.equals("threadLocalEcImplicitlyCa")) {
            if (securityManager != null) {
                ProviderConfigurationPermission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.getCFCAProviderName(), "threadLocalEcImplicitlyCa");
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if (!(parameter instanceof ECParameterSpec) && parameter != null) {
                throw new IllegalArgumentException("not a valid ECParameterSpec");
            }
            ECParameterSpec curveSpec = (ECParameterSpec)parameter;
            if (curveSpec == null) {
                this.ecThreadSpec.set(null);
                return;
            } else {
                this.ecThreadSpec.set(curveSpec);
            }
            return;
        } else if (parameterName.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                ProviderConfigurationPermission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.getCFCAProviderName(), "ecImplicitlyCa");
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            if (!(parameter instanceof ECParameterSpec) && parameter != null) throw new IllegalArgumentException("not a valid ECParameterSpec");
            this.ecImplicitCaParams = (ECParameterSpec)parameter;
            return;
        } else if (parameterName.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                ProviderConfigurationPermission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.getCFCAProviderName(), "threadLocalDhDefaultParams");
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(parameter instanceof DHParameterSpec) && !(parameter instanceof DHParameterSpec[]) && parameter != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            Object dhSpec = parameter;
            if (dhSpec == null) {
                this.dhThreadSpec.set(null);
                return;
            } else {
                this.dhThreadSpec.set(dhSpec);
            }
            return;
        } else {
            if (!parameterName.equals("DhDefaultParams")) return;
            if (securityManager != null) {
                ProviderConfigurationPermission BC_DH_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.getCFCAProviderName(), "DhDefaultParams");
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(parameter instanceof DHParameterSpec) && !(parameter instanceof DHParameterSpec[]) && parameter != null) throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            this.dhDefaultParams = parameter;
        }
    }

    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec spec = (ECParameterSpec)this.ecThreadSpec.get();
        if (spec != null) {
            return spec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters(int keySize) {
        Object params = this.dhThreadSpec.get();
        if (params == null) {
            params = this.dhDefaultParams;
        }
        if (params instanceof DHParameterSpec) {
            DHParameterSpec spec = (DHParameterSpec)params;
            if (spec.getP().bitLength() == keySize) {
                return spec;
            }
        } else if (params instanceof DHParameterSpec[]) {
            DHParameterSpec[] specs = (DHParameterSpec[])params;
            for (int i = 0; i != specs.length; ++i) {
                if (specs[i].getP().bitLength() != keySize) continue;
                return specs[i];
            }
        }
        return null;
    }
}

