/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.envelope.EnvelopeDecryptHelper;
import cfca.sadk.envelope.EnvelopeEncryptHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.system.Environments;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Assert;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;

public class EnvelopeUtil {
    public static final int recipient_policy_requiredSubjectKeyId = 0;
    public static final int recipient_policy_useSubjectKeyIdExt = 1;
    public static final int recipient_policy_useIssuerAndSerialNumber = 2;

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        return EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeMessage>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n symmetricAlgorithm: ");
            buffer.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer.append("\n receiverCerts: ");
            buffer.append(SADKDebugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                Assert.notEmpty(sourceData, "sourceData must not be null or empty");
                if (receiverCerts == null) throw new PKIException("required receiverCerts!");
                if (receiverCerts.length < 1) throw new PKIException("required receiverCerts!");
                if (receiverCerts[0] == null) {
                    throw new PKIException("required receiverCerts!");
                }
                if (receiverCerts.length > 1) {
                    throw new PKIException("receiverCerts more than one cert!");
                }
                EnvelopeEncryptHelper envelopeUtil = new EnvelopeEncryptHelper(receiverCerts[0].isSM2Cert());
                byte[] base64EnvelopeMessageBytes = envelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("envelopeMessage<<<<<<Finished: base64EnvelopeMessageBytes=" + SADKDebugger.dumpBase64(base64EnvelopeMessageBytes));
                }
                byArray = base64EnvelopeMessageBytes;
                Object var10_12 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("envelopeMessage<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("envelopeMessage<<<<<<Failure", e);
                throw new PKIException("EnvelopeMessage Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeMessage>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n symmetricAlgorithm: ");
            buffer.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer.append("\n receiverCerts: ");
            buffer.append(SADKDebugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("envelopeMessage>>>>>>Running");
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n symmetricAlgorithm: ");
        buffer.append(SADKDebugger.dump(symmetricAlgorithm));
        buffer.append("\n receiverCerts: ");
        buffer.append(SADKDebugger.dump(receiverCerts));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        buffer.append("\n recipientPolicyType: " + recipientPolicyType);
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        EnvelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        EnvelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void envelopeFile(String inSourceFilePath, String outEnvelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws PKIException {
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeFile>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(inSourceFilePath));
            buffer.append("\n outEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer.append("\n symmetricAlgorithm: ");
            buffer.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer.append("\n receiverCerts: ");
            buffer.append(SADKDebugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            block8: {
                try {
                    Assert.hasFileLength(inSourceFilePath);
                    if (receiverCerts == null) throw new PKIException("required receiverCerts!");
                    if (receiverCerts.length < 1) throw new PKIException("required receiverCerts!");
                    if (receiverCerts[0] == null) {
                        throw new PKIException("required receiverCerts!");
                    }
                    if (receiverCerts.length > 1) {
                        throw new PKIException("receiverCerts more than one cert!");
                    }
                    EnvelopeEncryptHelper envelopeUtil = new EnvelopeEncryptHelper(receiverCerts[0].isSM2Cert());
                    envelopeUtil.envelopeFile(inSourceFilePath, outEnvelopedFilePath, symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block8;
                    LoggerManager.debugLogger.debug("envelopeFile<<<<<<Finished: outEnvelopedFilePath=" + outEnvelopedFilePath);
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("envelopeFile<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("envelopeFile<<<<<<Failure", e);
                    throw new PKIException("EnvelopeFile Failure", e);
                }
            }
            Object var9_10 = null;
            if (!isFailed) return;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) return;
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeFile>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(inSourceFilePath));
            buffer.append("\n outEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer.append("\n symmetricAlgorithm: ");
            buffer.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer.append("\n receiverCerts: ");
            buffer.append(SADKDebugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("envelopeFile>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(inSourceFilePath));
            buffer.append("\n outEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(outEnvelopedFilePath));
            buffer.append("\n symmetricAlgorithm: ");
            buffer.append(SADKDebugger.dump(symmetricAlgorithm));
            buffer.append("\n receiverCerts: ");
            buffer.append(SADKDebugger.dump(receiverCerts));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n recipientPolicyType: " + recipientPolicyType);
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void openEnvelopedFile(String inEnvelopedFilePath, String outSourceFilePath, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEnvelopedFile>>>>>>Running");
            buffer.append("\n inEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer.append("\n outSourceFilePath: ");
            buffer.append(SADKDebugger.dump(outSourceFilePath));
            buffer.append("\n recipientPrivateKey: ");
            buffer.append(SADKDebugger.dump(recipientPrivateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        Assert.hasFileLength(inEnvelopedFilePath);
        try {
            block6: {
                try {
                    EnvelopeDecryptHelper.openEnvelopedFile(inEnvelopedFilePath, outSourceFilePath, recipientPrivateKey, recipientCert, session);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block6;
                    LoggerManager.debugLogger.debug("openEnvelopedFile<<<<<<Finished: outSourceFilePath=" + outSourceFilePath);
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("openEnvelopedFile<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("openEnvelopedFile<<<<<<Failure", e);
                    throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
                }
            }
            Object var8_9 = null;
            if (!isFailed) return;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) return;
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEnvelopedFile>>>>>>Running");
            buffer.append("\n inEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer.append("\n outSourceFilePath: ");
            buffer.append(SADKDebugger.dump(outSourceFilePath));
            buffer.append("\n recipientPrivateKey: ");
            buffer.append(SADKDebugger.dump(recipientPrivateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEnvelopedFile>>>>>>Running");
            buffer.append("\n inEnvelopedFilePath: ");
            buffer.append(SADKDebugger.dump(inEnvelopedFilePath));
            buffer.append("\n outSourceFilePath: ");
            buffer.append(SADKDebugger.dump(outSourceFilePath));
            buffer.append("\n recipientPrivateKey: ");
            buffer.append(SADKDebugger.dump(recipientPrivateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] openEvelopedMessage(byte[] base64EnvelopeMessage, PrivateKey recipientPrivateKey, X509Cert recipientCert, Session session) throws PKIException {
        byte[] byArray;
        boolean isFailed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEvelopedMessage>>>>>>Running");
            buffer.append("\n base64EnvelopeMessage: ");
            buffer.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
            buffer.append("\n recipientPrivateKey: ");
            buffer.append(SADKDebugger.dump(recipientPrivateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            try {
                byte[] sourceData = EnvelopeDecryptHelper.openEnvelopedMessage(base64EnvelopeMessage, recipientPrivateKey, recipientCert, session);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("openEvelopedMessage<<<<<<Finished: sourceData=" + SADKDebugger.dump(sourceData));
                }
                byArray = sourceData;
                Object var8_9 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("openEvelopedMessage<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("openEvelopedMessage<<<<<<Failure", e);
                throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("openEvelopedMessage>>>>>>Running");
            buffer.append("\n base64EnvelopeMessage: ");
            buffer.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
            buffer.append("\n recipientPrivateKey: ");
            buffer.append(SADKDebugger.dump(recipientPrivateKey));
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("openEvelopedMessage>>>>>>Running");
        buffer.append("\n base64EnvelopeMessage: ");
        buffer.append(SADKDebugger.dumpBase64(base64EnvelopeMessage));
        buffer.append("\n recipientPrivateKey: ");
        buffer.append(SADKDebugger.dump(recipientPrivateKey));
        buffer.append("\n recipientCert: ");
        buffer.append(SADKDebugger.dump(recipientCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    public static boolean isRecipient(X509Cert recipientCert, byte[] base64EnvelopeData) throws PKIException {
        ASN1Set receivers;
        byte[] cmsEnvelopedData;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("isRecipient>>>>>>Running");
            buffer.append("\n recipientCert: ");
            buffer.append(SADKDebugger.dump(recipientCert));
            buffer.append("\n base64EnvelopeData: ");
            buffer.append(SADKDebugger.dumpBase64(base64EnvelopeData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (recipientCert == null) {
            throw new PKIException("isRecipient: required recipientCert");
        }
        if (base64EnvelopeData == null) {
            throw new PKIException("isRecipient: required base64EnvelopeData");
        }
        try {
            cmsEnvelopedData = Base64.decode(base64EnvelopeData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", (Throwable)e);
            throw new PKIException("isRecipient: base64EnvelopeData invalid");
        }
        try {
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(cmsEnvelopedData);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            receivers = enData.getRecipientInfos();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", (Throwable)e);
            throw new PKIException("isRecipient: cmsEnvelopedData invalid");
        }
        try {
            if (receivers == null) {
                return false;
            }
            int len = receivers.size();
            for (int i = 0; i < len; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !recipientCert.isRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()))) continue;
                return true;
            }
            return false;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("isRecipient<<<<<<Failure", e);
            throw new PKIException("isRecipient Failure", e);
        }
    }

    static {
        Environments.environments();
    }
}

