/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import java.io.EOFException;
import java.io.IOException;

final class CRLLengths {
    final int asn1Length;
    final int headLength;
    final int valueLength;

    CRLLengths(int asn1Length, int headLength, int valueLength) {
        this.asn1Length = asn1Length;
        this.headLength = headLength;
        this.valueLength = valueLength;
    }

    static CRLLengths buildLengthsFrom(byte[] encoding, int offset, int asn1Tag) throws IOException {
        int asn1Length;
        if (encoding == null || encoding.length < 2) {
            throw new EOFException("asn1Tag - encoding is null or too small");
        }
        int tag = encoding[offset++] & 0xFF;
        if (asn1Tag != 0 && tag != asn1Tag) {
            throw new EOFException("asn1Tag - unexpected tag value");
        }
        int headxLength = 1;
        int valueLength = encoding[offset++] & 0xFF;
        ++headxLength;
        if (valueLength == 128) {
            throw new EOFException("asn1Tag - BER tag found");
        }
        if (valueLength > 127) {
            int tagLength = valueLength & 0x7F;
            if (tagLength > 4) {
                throw new IOException("asn1Tag - DER tagLength more than 4 bytes: " + tagLength);
            }
            if (encoding.length < offset + tagLength) {
                throw new EOFException("asn1Tag - EOF found encodingLength");
            }
            headxLength += tagLength;
            valueLength = 0;
            int low = 0;
            for (int i = 0; i < tagLength; ++i) {
                low = encoding[offset++] & 0xFF;
                valueLength = (valueLength << 8) + low;
            }
            if (valueLength < 0) {
                throw new IOException("asn1Tag - negative valueLength found");
            }
        }
        if ((asn1Length = headxLength + valueLength) < 0) {
            throw new IOException("asn1Tag - negative asn1Length found");
        }
        return new CRLLengths(asn1Length, headxLength, valueLength);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("CRLDerLengths [asn1Length=");
        builder.append(this.asn1Length);
        builder.append(", headLength=");
        builder.append(this.headLength);
        builder.append(", valueLength=");
        builder.append(this.valueLength);
        builder.append("]");
        return builder.toString();
    }

    byte[] valueFrom(byte[] encoding, int offset) throws IOException {
        byte[] value = new byte[this.asn1Length];
        System.arraycopy(encoding, offset, value, 0, value.length);
        return value;
    }
}

