/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x500.style.BCStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class X509CertGenerator {
    private Mechanism mechanism = null;
    private V3TBSCertificateGenerator tbsCertGen = new V3TBSCertificateGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private PublicKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificate tbsCert = null;
    private Hashtable extensionSet = new Hashtable();

    public void setSerialNumber(String serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.setSerialNumber(new BigInteger(serialNumber, 16));
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSerialNumber>>>>>>Running: serialNumber=" + SADKDebugger.dump(serialNumber));
        }
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new ASN1Integer(serialNumber));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSerialNumber<<<<<<Finished");
        }
    }

    public void setSubject(String subjectDN) throws PKIException {
        this.setSubject(BCStyle.INSTANCE, subjectDN);
    }

    public void setSubject(X500NameStyle style, String subjectDN) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSubject>>>>>>Running: subjectDN=" + subjectDN + ",style=" + style);
        }
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (subjectDN == null || subjectDN.trim().length() == 0) {
            throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
        }
        this.subject = subjectDN;
        this.tbsCertGen.setSubject(new X500Name(style, subjectDN));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSubject<<<<<<Finished");
        }
    }

    public void setIssuer(String issuerDN) throws PKIException {
        this.setIssuer(BCStyle.INSTANCE, issuerDN);
    }

    public void setIssuer(X500NameStyle style, String issuerDN) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuer>>>>>>Running: issuerDN=" + issuerDN + ",style=" + style);
        }
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (issuerDN == null || issuerDN.trim().length() == 0) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        this.issuer = issuerDN;
        this.tbsCertGen.setIssuer(new X500Name(style, issuerDN));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuer<<<<<<Finished");
        }
    }

    public void setNotBefore(Date notBefore) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNotBefore>>>>>>Running: notBefore=" + notBefore);
        }
        if (notBefore == null) {
            throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNotBefore<<<<<<Finished");
        }
    }

    public void setNotAfter(Date notAfter) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNotAfter>>>>>>Running: notAfter=" + notAfter);
        }
        if (notAfter == null) {
            throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNotAfter<<<<<<Finished");
        }
    }

    public void setPublicKey(PublicKey publicKey) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setPublicKey>>>>>>Running: publicKey=" + SADKDebugger.dump(publicKey));
        }
        try {
            if (publicKey == null) {
                throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
            }
            this.pubKey = publicKey;
            SubjectPublicKeyInfo spki = null;
            try {
                spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.PARSER + PKIException.KEY_SPKI, PKIException.KEY_SPKI_DES, ex);
            }
            this.tbsCertGen.setSubjectPublicKeyInfo(spki);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("setPublicKey<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("setPublicKey<<<<<<Failure", e);
            throw new PKIException("setPublicKey Failure: " + e.getMessage(), e);
        }
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSignatureAlg>>>>>>Running: signatureAlgorithm=" + signatureAlgorithm);
        }
        try {
            if (signatureAlgorithm == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            this.mechanism = Mechanisms.signMechanismFrom(signatureAlgorithm);
            if (this.mechanism == null) {
                throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ": " + signatureAlgorithm);
            }
            ASN1ObjectIdentifier oid = Mechanism.getObjectIdentifier(signatureAlgorithm);
            this.sigAlg = new AlgorithmIdentifier(oid, DERNull.INSTANCE);
            this.tbsCertGen.setSignature(this.sigAlg);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("setSignatureAlg<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("setSignatureAlg<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("setSignatureAlg<<<<<<Failure", e);
            throw new PKIException("setSignatureAlg Failure: " + e.getMessage(), e);
        }
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuerUniqueID>>>>>>Running: issuerUniqueID=" + SADKDebugger.dump(issuerUniqueID));
        }
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuerUniqueID<<<<<<Finished");
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSubjectUniqueID>>>>>>Running: subjectUniqueID=" + SADKDebugger.dump(subjectUniqueID));
        }
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSubjectUniqueID<<<<<<Finished");
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtension>>>>>>Running: extension=" + SADKDebugger.dump(extension));
        }
        ASN1ObjectIdentifier derOID = extension.getExtnId();
        this.extensionSet.put(derOID, extension);
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtension<<<<<<Finished");
        }
    }

    private Extensions generaterExtensions() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("generaterExtensions::>>>>>>Running: ");
        }
        Extensions extensions = null;
        if (this.extensionSet != null) {
            Iterator itor = this.extensionSet.entrySet().iterator();
            Vector v = new Vector();
            while (itor.hasNext()) {
                Map.Entry entryt = itor.next();
                v.add(entryt.getValue());
            }
            Extension[] extensionArray = new Extension[v.size()];
            v.toArray(extensionArray);
            extensions = new Extensions(extensionArray);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("generaterExtensions::<<<<<<Finished: extensions=" + SADKDebugger.dump(extensions));
        }
        return extensions;
    }

    public byte[] generateX509Cert(PrivateKey privateKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("generateX509Cert>>>>>>Running: session=" + SADKDebugger.dump(session));
        }
        try {
            if (this.issuer == null || this.issuer.trim().length() == 0) {
                throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
            }
            if (this.subject == null || this.subject.trim().length() == 0) {
                throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
            }
            if (this.pubKey == null) {
                throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
            }
            if (this.sigAlg == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            if (this.serialNumber == null) {
                throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
            }
            if (this.notBefore == null) {
                throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
            }
            if (this.notAfter == null) {
                throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
            }
            this.generateSignature(privateKey, session);
            byte[] certBytes = this.constructCertificate();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateX509Cert<<<<<<Finished: certBytes=" + SADKDebugger.dump(certBytes));
            }
            return certBytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateX509Cert<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateX509Cert<<<<<<Failure", e);
            throw new PKIException("generateX509Cert Failure: " + e.getMessage(), e);
        }
    }

    private void generateSignature(PrivateKey privateKey, Session session) throws PKIException {
        try {
            if (this.extensionSet.size() > 0) {
                this.tbsCertGen.setExtensions(this.generaterExtensions());
            }
            this.tbsCert = this.tbsCertGen.generateTBSCertificate();
            byte[] bTBSCert = null;
            try {
                bTBSCert = ASN1Parser.parseDERObj2Bytes(this.tbsCert);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.TBSCERT_BYTES, PKIException.TBSCERT_BYTES_DES, ex);
            }
            byte[] signatureData = null;
            try {
                signatureData = session.sign(this.mechanism, privateKey, bTBSCert);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
            }
            byte[] signatureBytes = null;
            if ("SM2".equalsIgnoreCase(privateKey.getAlgorithm()) || this.mechanism.getMechanismType().toUpperCase().contains("SM2")) {
                ASN1SM2Signature asn1Value = new ASN1SM2Signature(signatureData);
                signatureBytes = asn1Value.getEncoded();
            } else {
                signatureBytes = Mechanisms.isECDSA(privateKey.getAlgorithm()) || Mechanisms.isECDSA(this.mechanism) ? this.checkECCSignValue(signatureData) : signatureData;
            }
            this.signature = new DERBitString(signatureBytes);
        }
        catch (PKIException e) {
            throw new PKIException("generateSignature failure", e);
        }
        catch (Throwable e) {
            throw new PKIException("generateSignature failure", e);
        }
    }

    private byte[] constructCertificate() throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("constructCertificate::>>>>>>Running");
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.tbsCert);
            v.add(this.sigAlg);
            v.add(this.signature);
            DERSequence derSeq = new DERSequence(v);
            byte[] certData = null;
            try {
                certData = ASN1Parser.parseDERObj2Bytes(derSeq);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.CERT_BYTES, PKIException.CERT_BYTES_DES, ex);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("constructCertificate::<<<<<<Finished: certData=" + SADKDebugger.dump(certData));
            }
            return certData;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("constructCertificate::<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("constructCertificate::<<<<<<Failure", e);
            throw new PKIException("constructCertificate Failure: " + e.getMessage(), e);
        }
    }

    private byte[] checkECCSignValue(byte[] signValue) throws Exception {
        ASN1Integer sInt;
        ASN1Integer rInt;
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance(signValue);
            Enumeration values = seq.getObjects();
            if (seq.size() != 2) {
                throw new Exception("ECCSignValue required 2-Node: R+S");
            }
            rInt = (ASN1Integer)values.nextElement();
            sInt = (ASN1Integer)values.nextElement();
        }
        catch (Exception e) {
            throw new Exception("ECCSignValue decode failed when decodeRS", e);
        }
        if (rInt == null || sInt == null) {
            throw new Exception("ECCSignValue required R+S");
        }
        return signValue;
    }
}

