/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conf;

import cfca.sadk.timestamp.client.env.AbstractJavaVendor;
import cfca.sadk.timestamp.client.utils.TscPasswordTool;
import cfca.sadk.timestamp.client.utils.TscPropsUtil;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAException;
import java.util.Arrays;
import java.util.Properties;

public final class TscLayeredConf
implements Cloneable {
    private String sslProtocol;
    private String jksTrustFilePath;
    private String jksTruestFilePassword;
    private String jksKeyStoreFilePath;
    private String jksKeyStoreFilePassword;
    private boolean hostnameChecker;
    private String keyManagerFactoryType;
    private String trustManagerFactoryType;
    private String[] supportedProtocols;
    private String[] supportedCipherSuites;

    public TscLayeredConf() {
        this.jksTrustFilePath = null;
        this.jksTruestFilePassword = null;
        this.jksKeyStoreFilePath = null;
        this.jksKeyStoreFilePassword = null;
        this.sslProtocol = null;
        this.hostnameChecker = true;
        this.keyManagerFactoryType = AbstractJavaVendor.KEY_MANAGER_FACTORY_ALGORITHM;
        this.trustManagerFactoryType = AbstractJavaVendor.TRUST_MANAGER_FACTORY_ALGORITHM;
        this.supportedProtocols = null;
        this.supportedCipherSuites = null;
    }

    public TscLayeredConf(Properties properties) throws TSAException {
        String jksTruestFilePassword = TscPropsUtil.getString(properties, "timestamp.ssl.jksTrustFilePassword", null);
        String jksKeyStoreFilePassword = TscPropsUtil.getString(properties, "timestamp.ssl.jksKeyStoreFilePassword", null);
        this.jksTrustFilePath = TscPropsUtil.getString(properties, "timestamp.ssl.jksTrustFilePath", null);
        this.jksTruestFilePassword = TscPasswordTool.readPassword(jksTruestFilePassword, "jksTruestFilePassword");
        this.jksKeyStoreFilePath = TscPropsUtil.getString(properties, "timestamp.ssl.jksKeyStoreFilePath", null);
        this.jksKeyStoreFilePassword = TscPasswordTool.readPassword(jksKeyStoreFilePassword, "jksKeyStoreFilePassword");
        this.sslProtocol = TscPropsUtil.getString(properties, "timestamp.ssl.protocol", null);
        this.hostnameChecker = TscPropsUtil.getBoolean(properties, "timestamp.ssl.hostnameChecker", true);
        this.keyManagerFactoryType = TscPropsUtil.getString(properties, "timestamp.ssl.jksKeyManagerFactoryType", AbstractJavaVendor.KEY_MANAGER_FACTORY_ALGORITHM);
        this.trustManagerFactoryType = TscPropsUtil.getString(properties, "timestamp.ssl.jksTrustManagerFactoryType", AbstractJavaVendor.TRUST_MANAGER_FACTORY_ALGORITHM);
        this.supportedProtocols = TscPropsUtil.getStrings(properties, "timestamp.ssl.supportedProtocols", null);
        this.supportedCipherSuites = TscPropsUtil.getStrings(properties, "timestamp.ssl.supportedCipherSuites", null);
    }

    public final String getKeyManagerAlgorithmType(boolean isGMSSL) {
        String managerAlgorithmType = isGMSSL ? "GMTX509" : (TscStrings.isEmpty(this.keyManagerFactoryType) ? AbstractJavaVendor.KEY_MANAGER_FACTORY_ALGORITHM : this.keyManagerFactoryType);
        return managerAlgorithmType;
    }

    public final String getTrustManagerAlgorithmType(boolean isGMSSL) {
        String managerAlgorithmType = isGMSSL ? "GMTX509" : (TscStrings.isEmpty(this.trustManagerFactoryType) ? AbstractJavaVendor.TRUST_MANAGER_FACTORY_ALGORITHM : this.trustManagerFactoryType);
        return managerAlgorithmType;
    }

    public final boolean isGMSSL() {
        return "GMTLSv1.1".equalsIgnoreCase(this.sslProtocol);
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public TscLayeredConf setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public String getJksTrustFilePath() {
        return this.jksTrustFilePath;
    }

    public TscLayeredConf setJksTrustFilePath(String jksTrustFilePath) {
        this.jksTrustFilePath = jksTrustFilePath;
        return this;
    }

    public String getJksTrustFilePassword() {
        return this.jksTruestFilePassword;
    }

    public TscLayeredConf setJksTruestFilePassword(String jksTruestFilePassword) {
        this.jksTruestFilePassword = jksTruestFilePassword;
        return this;
    }

    public String getJksKeyStoreFilePath() {
        return this.jksKeyStoreFilePath;
    }

    public TscLayeredConf setJksKeyStoreFilePath(String jksKeyStoreFilePath) {
        this.jksKeyStoreFilePath = jksKeyStoreFilePath;
        return this;
    }

    public String getJksKeyStoreFilePassword() {
        return this.jksKeyStoreFilePassword;
    }

    public TscLayeredConf setJksKeyStoreFilePassword(String jksKeyStoreFilePassword) {
        this.jksKeyStoreFilePassword = jksKeyStoreFilePassword;
        return this;
    }

    public boolean isHostnameChecker() {
        return this.hostnameChecker;
    }

    public TscLayeredConf setHostnameChecker(boolean hostnameChecker) {
        this.hostnameChecker = hostnameChecker;
        return this;
    }

    public String getKeyManagerFactoryType() {
        return this.keyManagerFactoryType;
    }

    public TscLayeredConf setKeyManagerFactoryType(String keyManagerFactoryType) {
        this.keyManagerFactoryType = keyManagerFactoryType;
        return this;
    }

    public String getTrustManagerFactoryType() {
        return this.trustManagerFactoryType;
    }

    public TscLayeredConf setTrustManagerFactoryType(String trustManagerFactoryType) {
        this.trustManagerFactoryType = trustManagerFactoryType;
        return this;
    }

    public String[] getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public TscLayeredConf setSupportedProtocols(String[] supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    public String[] getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public TscLayeredConf setSupportedCipherSuites(String[] supportedCipherSuites) {
        this.supportedCipherSuites = supportedCipherSuites;
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String toString() {
        return this.append(new StringBuilder(256), false).toString();
    }

    public final StringBuilder append(StringBuilder builder, boolean hidden) {
        if (builder != null) {
            builder.append("\n\t [TLS/SSL/GMTLS]TssLayeredConf [");
            builder.append("\n\t\t sslProtocol=").append(this.sslProtocol);
            builder.append("\n\t\t jksTrustFilePath=").append(this.jksTrustFilePath);
            builder.append("\n\t\t jksTruestFilePassword=").append(hidden ? "******" : this.jksTruestFilePassword);
            builder.append("\n\t\t jksKeyStoreFilePath=").append(this.jksKeyStoreFilePath);
            builder.append("\n\t\t jksKeyStoreFilePassword=").append(hidden ? "******" : this.jksKeyStoreFilePassword);
            builder.append("\n\t\t hostnameChecker=").append(this.hostnameChecker);
            builder.append("\n\t\t keyManagerFactoryType=").append(this.keyManagerFactoryType);
            builder.append("\n\t\t trustManagerFactoryType=").append(this.trustManagerFactoryType);
            builder.append("\n\t\t supportedProtocols=").append(this.supportedProtocols == null ? "" : Arrays.asList(this.supportedProtocols));
            builder.append("\n\t\t supportedCipherSuites=").append(this.supportedCipherSuites == null ? "" : Arrays.asList(this.supportedCipherSuites));
            builder.append("\n\t\t ]");
        }
        return builder;
    }
}

