/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.DSAParameters;
import cfca.sadk.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAUtil {
    public static final List<ASN1ObjectIdentifier> dsaOids = DSAUtil.buildDsaOids();

    public static final List<ASN1ObjectIdentifier> buildDsaOids() {
        ArrayList<ASN1ObjectIdentifier> dsaOids = new ArrayList<ASN1ObjectIdentifier>(2);
        dsaOids.add(X9ObjectIdentifiers.id_dsa);
        dsaOids.add(OIWObjectIdentifiers.dsaWithSHA1);
        return Collections.unmodifiableList(dsaOids);
    }

    public static boolean isDsaOid(ASN1ObjectIdentifier algOid) {
        int size = dsaOids.size();
        for (int i = 0; i < size; ++i) {
            if (!algOid.equals(dsaOids.get(i))) continue;
            return true;
        }
        return false;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof DSAPublicKey) {
            DSAPublicKey k = (DSAPublicKey)key;
            return new DSAPublicKeyParameters(k.getY(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey k = (DSAPrivateKey)key;
            return new DSAPrivateKeyParameters(k.getX(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA private key.");
    }
}

