/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.ofd.base.bean.crl.X509CRLMap;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.x509.certificate.X509CRL;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class CrlManager {
    private static final Logger logger = LoggerFactory.getLogger(CrlManager.class);
    private static Set<X509CRLMap> crlCachePool = new HashSet<X509CRLMap>();

    public static void init(String crlRootDir) throws SealException, IOException, PKIException {
        logger.info("Crl manager init dir({}) start", (Object)crlRootDir);
        if (StringUtil.isEmpty(crlRootDir)) {
            throw new IllegalArgumentException("crlRootDir can not be empty");
        }
        File crlRootDirFile = new File(crlRootDir);
        if (!crlRootDirFile.exists()) {
            throw new SealException("the crlRootDir: " + crlRootDir + " is not exist");
        }
        File[] crlDirFileGroup = crlRootDirFile.listFiles();
        if (crlDirFileGroup != null && crlDirFileGroup.length > 0) {
            for (File crlDirFile : crlDirFileGroup) {
                String crlCacheKey = crlDirFile.getName();
                File crlFile = new File(crlDirFile.getAbsolutePath());
                if (!crlFile.exists() || !crlFile.isFile() || !crlCacheKey.endsWith(".crl")) continue;
                byte[] crlFileData = FileUtils.readFileToByteArray((File)crlFile);
                X509CRL x509CRL = new X509CRL(crlFileData);
                crlCachePool.add(new X509CRLMap(x509CRL));
                logger.info("Crl manager add crl(key:{})", (Object)crlCacheKey);
            }
        }
        logger.info("Crl manager init dir({}) successfully\n", (Object)crlRootDir);
    }

    public static boolean isRevoked(String sn, Date signDate) {
        X509CRLMap crlMap;
        Iterator<X509CRLMap> iterator = crlCachePool.iterator();
        boolean isRevoked = false;
        while (iterator.hasNext() && !(isRevoked = (crlMap = iterator.next()).isRevoked(sn, signDate))) {
        }
        return isRevoked;
    }
}

