/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.truetype;

import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.GlyphTable;

public final class SimpleGlyph
extends Glyph {
    private static final int FLAG_ONCURVE = 1;
    private static final int FLAG_XSHORT = 2;
    private static final int FLAG_YSHORT = 4;
    private static final int FLAG_REPEAT = 8;
    private static final int FLAG_XREPEATSIGN = 16;
    private static final int FLAG_YREPEATSIGN = 32;
    private int instructionSize;
    private int numberOfPoints;
    private int instructionsOffset;
    private int flagsOffset;
    private int xCoordinatesOffset;
    private int yCoordinatesOffset;
    private int flagByteCount;
    private int xByteCount;
    private int yByteCount;
    private int[] xCoordinates;
    private int[] yCoordinates;
    private boolean[] onCurve;
    private int[] contourIndex;

    SimpleGlyph(ReadableFontData data, int offset, int length) {
        super(data, offset, length, Glyph.GlyphType.Simple);
    }

    private SimpleGlyph(ReadableFontData data) {
        super(data, Glyph.GlyphType.Simple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            if (this.readFontData().length() == 0) {
                this.instructionSize = 0;
                this.numberOfPoints = 0;
                this.instructionsOffset = 0;
                this.flagsOffset = 0;
                this.xCoordinatesOffset = 0;
                this.yCoordinatesOffset = 0;
                return;
            }
            this.instructionSize = this.data.readUShort(GlyphTable.Offset.simpleEndPtsOfCountours.offset + this.numberOfContours() * FontData.DataSize.USHORT.size());
            this.instructionsOffset = GlyphTable.Offset.simpleEndPtsOfCountours.offset + (this.numberOfContours() + 1) * FontData.DataSize.USHORT.size();
            this.flagsOffset = this.instructionsOffset + this.instructionSize * FontData.DataSize.BYTE.size();
            this.numberOfPoints = this.contourEndPoint(this.numberOfContours() - 1) + 1;
            this.xCoordinates = new int[this.numberOfPoints];
            this.yCoordinates = new int[this.numberOfPoints];
            this.onCurve = new boolean[this.numberOfPoints];
            this.parseData(false);
            this.xCoordinatesOffset = this.flagsOffset + this.flagByteCount * FontData.DataSize.BYTE.size();
            this.yCoordinatesOffset = this.xCoordinatesOffset + this.xByteCount * FontData.DataSize.BYTE.size();
            this.contourIndex = new int[this.numberOfContours() + 1];
            this.contourIndex[0] = 0;
            for (int contour = 0; contour < this.contourIndex.length - 1; ++contour) {
                this.contourIndex[contour + 1] = this.contourEndPoint(contour) + 1;
            }
            this.parseData(true);
            int nonPaddedDataLength = 5 * FontData.DataSize.SHORT.size() + this.numberOfContours() * FontData.DataSize.USHORT.size() + FontData.DataSize.USHORT.size() + this.instructionSize * FontData.DataSize.BYTE.size() + this.flagByteCount * FontData.DataSize.BYTE.size() + this.xByteCount * FontData.DataSize.BYTE.size() + this.yByteCount * FontData.DataSize.BYTE.size();
            this.setPadding(this.dataLength() - nonPaddedDataLength);
            this.initialized = true;
        }
    }

    private void parseData(boolean fillArrays) {
        int flag = 0;
        int flagRepeat = 0;
        int flagIndex = 0;
        int xByteIndex = 0;
        int yByteIndex = 0;
        for (int pointIndex = 0; pointIndex < this.numberOfPoints; ++pointIndex) {
            if (flagRepeat == 0) {
                if (((flag = this.flagAsInt(flagIndex++)) & 8) == 8) {
                    flagRepeat = this.flagAsInt(flagIndex++);
                }
            } else {
                --flagRepeat;
            }
            if (fillArrays) {
                boolean bl = this.onCurve[pointIndex] = (flag & 1) == 1;
            }
            if ((flag & 2) == 2) {
                if (fillArrays) {
                    this.xCoordinates[pointIndex] = this.data.readUByte(this.xCoordinatesOffset + xByteIndex);
                    int n = pointIndex;
                    this.xCoordinates[n] = this.xCoordinates[n] * ((flag & 0x10) == 16 ? 1 : -1);
                }
                ++xByteIndex;
            } else if ((flag & 0x10) != 16) {
                if (fillArrays) {
                    this.xCoordinates[pointIndex] = this.data.readShort(this.xCoordinatesOffset + xByteIndex);
                }
                xByteIndex += 2;
            }
            if (fillArrays && pointIndex > 0) {
                int n = pointIndex;
                this.xCoordinates[n] = this.xCoordinates[n] + this.xCoordinates[pointIndex - 1];
            }
            if ((flag & 4) == 4) {
                if (fillArrays) {
                    this.yCoordinates[pointIndex] = this.data.readUByte(this.yCoordinatesOffset + yByteIndex);
                    int n = pointIndex;
                    this.yCoordinates[n] = this.yCoordinates[n] * ((flag & 0x20) == 32 ? 1 : -1);
                }
                ++yByteIndex;
            } else if ((flag & 0x20) != 32) {
                if (fillArrays) {
                    this.yCoordinates[pointIndex] = this.data.readShort(this.yCoordinatesOffset + yByteIndex);
                }
                yByteIndex += 2;
            }
            if (!fillArrays || pointIndex <= 0) continue;
            int n = pointIndex;
            this.yCoordinates[n] = this.yCoordinates[n] + this.yCoordinates[pointIndex - 1];
        }
        this.flagByteCount = flagIndex;
        this.xByteCount = xByteIndex;
        this.yByteCount = yByteIndex;
    }

    private int flagAsInt(int index) {
        return this.data.readUByte(this.flagsOffset + index * FontData.DataSize.BYTE.size());
    }

    public int contourEndPoint(int contour) {
        return this.data.readUShort(contour * FontData.DataSize.USHORT.size() + GlyphTable.Offset.simpleEndPtsOfCountours.offset);
    }

    @Override
    public int instructionSize() {
        this.initialize();
        return this.instructionSize;
    }

    @Override
    public ReadableFontData instructions() {
        this.initialize();
        return this.data.slice(this.instructionsOffset, this.instructionSize());
    }

    public int numberOfPoints(int contour) {
        this.initialize();
        if (contour >= this.numberOfContours()) {
            return 0;
        }
        return this.contourIndex[contour + 1] - this.contourIndex[contour];
    }

    public int xCoordinate(int contour, int point) {
        this.initialize();
        return this.xCoordinates[this.contourIndex[contour] + point];
    }

    public int yCoordinate(int contour, int point) {
        this.initialize();
        return this.yCoordinates[this.contourIndex[contour] + point];
    }

    public boolean onCurve(int contour, int point) {
        this.initialize();
        return this.onCurve[this.contourIndex[contour] + point];
    }

    @Override
    public String toString() {
        this.initialize();
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\tinstruction bytes = " + this.instructionSize() + "\n");
        for (int contour = 0; contour < this.numberOfContours(); ++contour) {
            for (int point = 0; point < this.numberOfPoints(contour); ++point) {
                sb.append("\t" + contour + ":" + point + " = [" + this.xCoordinate(contour, point) + ", " + this.yCoordinate(contour, point) + ", " + this.onCurve(contour, point) + "]\n");
            }
        }
        return sb.toString();
    }

    public static class SimpleGlyphBuilder
    extends Glyph.Builder<SimpleGlyph> {
        protected SimpleGlyphBuilder(WritableFontData data, int offset, int length) {
            super(data.slice(offset, length));
        }

        protected SimpleGlyphBuilder(ReadableFontData data, int offset, int length) {
            super(data.slice(offset, length));
        }

        @Override
        protected SimpleGlyph subBuildTable(ReadableFontData data) {
            return new SimpleGlyph(data, 0, data.length());
        }
    }

    public static final class SimpleContour
    extends Glyph.Contour {
        protected SimpleContour() {
        }
    }
}

