/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.conversion.eot;

import cfca.sadk.com.google.typography.font.tools.conversion.eot.BitIOWriter;

public class HuffmanEncoder {
    private static final int ROOT = 1;
    private TreeNode[] tree;
    private short[] symbolIndex;
    private int bitCount2;
    private int range;
    private BitIOWriter bits;

    public HuffmanEncoder(BitIOWriter bits, int range) {
        int i;
        this.bits = bits;
        this.range = range;
        HuffmanEncoder.bitsUsed(range - 1);
        this.bitCount2 = range > 256 && range < 512 ? HuffmanEncoder.bitsUsed(range - 257) : 0;
        this.symbolIndex = new short[range];
        int limit = 2 * range;
        this.tree = new TreeNode[limit];
        for (i = 0; i < limit; ++i) {
            this.tree[i] = new TreeNode();
        }
        for (i = 2; i < limit; ++i) {
            this.tree[i].up = (short)(i / 2);
            this.tree[i].weight = 1;
        }
        for (i = 1; i < range; ++i) {
            this.tree[i].left = (short)(2 * i);
            this.tree[i].right = (short)(2 * i + 1);
        }
        for (i = 0; i < range; ++i) {
            this.tree[i].code = (short)-1;
            this.tree[range + i].code = (short)i;
            this.tree[range + i].left = (short)-1;
            this.tree[range + i].right = (short)-1;
            this.symbolIndex[i] = (short)(range + i);
        }
        this.initWeight(1);
        if (this.bitCount2 != 0) {
            this.updateWeight(this.symbolIndex[256]);
            this.updateWeight(this.symbolIndex[257]);
            for (i = 0; i < 12; ++i) {
                this.updateWeight(this.symbolIndex[range - 3]);
            }
            for (i = 0; i < 6; ++i) {
                this.updateWeight(this.symbolIndex[range - 2]);
            }
        } else {
            for (int j = 0; j < 2; ++j) {
                for (int i2 = 0; i2 < range; ++i2) {
                    this.updateWeight(this.symbolIndex[i2]);
                }
            }
        }
    }

    String checkTree() {
        short a;
        int i;
        int i2;
        for (i2 = 1; i2 < this.range; ++i2) {
            if (this.tree[i2].code >= 0) continue;
            if (this.tree[this.tree[i2].left].up != i2) {
                return "tree[tree[" + i2 + "].left].up == " + this.tree[this.tree[i2].left].up + ", expected " + i2;
            }
            if (this.tree[this.tree[i2].right].up == i2) continue;
            return "tree[tree[" + i2 + "].right].up == " + this.tree[this.tree[i2].right].up + ", expected " + i2;
        }
        for (i2 = 1; i2 < this.range; ++i2) {
            if (this.tree[i2].code >= 0 || this.tree[i2].weight == this.tree[this.tree[i2].left].weight + this.tree[this.tree[i2].right].weight) continue;
            return "tree[" + i2 + "].weight == " + this.tree[i2].weight + ", expected " + this.tree[this.tree[i2].left].weight + " + " + this.tree[this.tree[i2].right].weight;
        }
        int j = this.range * 2 - 1;
        for (i = 1; i < j; ++i) {
            if (this.tree[i].weight >= this.tree[i + 1].weight) continue;
            return "tree[" + i + "].weight == " + this.tree[i].weight + ", tree[" + (i + 1) + ".weight == " + this.tree[i + 1].weight + ", not >=";
        }
        for (i = 2; i < j; ++i) {
            short b;
            if (this.tree[i].code >= 0 || (a = this.tree[i].left) - (b = this.tree[i].right) == 1 || a - b == -1) continue;
            return "tree[" + i + "].left == " + this.tree[i].left + ", tree[" + i + "].right] == " + this.tree[i].right + ", siblings not adjacent";
        }
        for (i = 2; i < this.range * 2; ++i) {
            a = this.tree[i].up;
            if (this.tree[a].left == i || this.tree[a].right == i) continue;
            return "tree[" + a + "].left != " + i + " && tree[" + a + "].right != " + i;
        }
        return null;
    }

    private int initWeight(int a) {
        if (this.tree[a].code < 0) {
            this.tree[a].weight = this.initWeight(this.tree[a].left) + this.initWeight(this.tree[a].right);
        }
        return this.tree[a].weight;
    }

    private void updateWeight(int a) {
        while (a != 1) {
            int weightA = this.tree[a].weight;
            int b = a - 1;
            if (this.tree[b].weight == weightA) {
                while (this.tree[--b].weight == weightA) {
                }
                if (++b > 1) {
                    this.swapNodes(a, b);
                    a = b;
                }
            }
            this.tree[a].weight = ++weightA;
            a = this.tree[a].up;
        }
        ++this.tree[a].weight;
    }

    private void swapNodes(int a, int b) {
        short upa = this.tree[a].up;
        short upb = this.tree[b].up;
        TreeNode tmp = this.tree[a];
        this.tree[a] = this.tree[b];
        this.tree[b] = tmp;
        this.tree[a].up = upa;
        this.tree[b].up = upb;
        short code = this.tree[a].code;
        if (code < 0) {
            this.tree[this.tree[a].left].up = (short)a;
            this.tree[this.tree[a].right].up = (short)a;
        } else {
            this.symbolIndex[code] = (short)a;
        }
        code = this.tree[b].code;
        if (code < 0) {
            this.tree[this.tree[b].left].up = (short)b;
            this.tree[this.tree[b].right].up = (short)b;
        } else {
            this.symbolIndex[code] = (short)b;
        }
    }

    public int writeSymbolCost(int symbol) {
        short a = this.symbolIndex[symbol];
        int sp = 0;
        do {
            ++sp;
        } while ((a = this.tree[a].up) != 1);
        return sp << 16;
    }

    public void writeSymbol(int symbol) {
        short up;
        short a;
        short aa = a = this.symbolIndex[symbol];
        boolean[] stack = new boolean[50];
        int sp = 0;
        do {
            up = this.tree[a].up;
            boolean bl = stack[sp++] = this.tree[up].right == a;
        } while ((a = up) != 1);
        do {
            this.bits.writeBit(stack[--sp]);
        } while (sp > 0);
        this.updateWeight(aa);
    }

    public static int bitsUsed(int x) {
        int i;
        for (i = 32; i > 1 && (x & 1 << i - 1) == 0; --i) {
        }
        return i;
    }

    private static class TreeNode {
        short up;
        short left;
        short right;
        short code;
        int weight;

        private TreeNode() {
        }
    }
}

