/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.forms;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;

public class PdfSigFieldLockDictionary
extends PdfObjectWrapper<PdfDictionary> {
    public PdfSigFieldLockDictionary() {
        this(new PdfDictionary());
    }

    public PdfSigFieldLockDictionary(PdfDictionary dict) {
        super(dict);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.SigFieldLock);
    }

    public PdfSigFieldLockDictionary setDocumentPermissions(LockPermissions permissions) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.P, PdfSigFieldLockDictionary.getLockPermission(permissions));
        return this;
    }

    public PdfSigFieldLockDictionary setFieldLock(LockAction action, String ... fields) {
        PdfArray fieldsArray = new PdfArray();
        for (String field : fields) {
            fieldsArray.add(new PdfString(field));
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Action, PdfSigFieldLockDictionary.getLockActionValue(action));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Fields, fieldsArray);
        return this;
    }

    public static PdfName getLockActionValue(LockAction action) {
        switch (action) {
            case ALL: {
                return PdfName.All;
            }
            case INCLUDE: {
                return PdfName.Include;
            }
            case EXCLUDE: {
                return PdfName.Exclude;
            }
        }
        return PdfName.All;
    }

    public static PdfNumber getLockPermission(LockPermissions permissions) {
        switch (permissions) {
            case NO_CHANGES_ALLOWED: {
                return new PdfNumber(1);
            }
            case FORM_FILLING: {
                return new PdfNumber(2);
            }
            case FORM_FILLING_AND_ANNOTATION: {
                return new PdfNumber(3);
            }
        }
        return new PdfNumber(0);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    public static enum LockPermissions {
        NO_CHANGES_ALLOWED,
        FORM_FILLING,
        FORM_FILLING_AND_ANNOTATION;

    }

    public static enum LockAction {
        ALL,
        INCLUDE,
        EXCLUDE;

    }
}

