/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.element;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import cfca.sadk.com.itextpdf.layout.element.BlockElement;
import cfca.sadk.com.itextpdf.layout.element.IBlockElement;
import cfca.sadk.com.itextpdf.layout.element.ILeafElement;
import cfca.sadk.com.itextpdf.layout.element.Image;
import cfca.sadk.com.itextpdf.layout.element.TabStop;
import cfca.sadk.com.itextpdf.layout.element.Text;
import cfca.sadk.com.itextpdf.layout.property.Leading;
import cfca.sadk.com.itextpdf.layout.renderer.CFCAParagraphRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Paragraph
extends BlockElement<Paragraph> {
    protected PdfName role = PdfName.P;
    protected AccessibilityProperties tagProperties;
    protected boolean selfBorder = false;

    public Paragraph() {
    }

    public Paragraph(String text) {
        this(new Text(text));
    }

    public Paragraph(Text text) {
        this.add(text);
    }

    public Paragraph add(String text) {
        return this.add(new Text(text));
    }

    public Paragraph add(ILeafElement element) {
        this.childElements.add(element);
        return this;
    }

    public Paragraph add(IBlockElement element) {
        this.childElements.add(element);
        return this;
    }

    public <T2 extends ILeafElement> Paragraph addAll(List<T2> elements) {
        for (ILeafElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public Paragraph addTabStops(TabStop ... tabStops) {
        this.addTabStopsAsProperty(Arrays.asList(tabStops));
        return this;
    }

    public Paragraph addTabStops(List<TabStop> tabStops) {
        this.addTabStopsAsProperty(tabStops);
        return this;
    }

    public Paragraph removeTabStop(float tabStopPosition) {
        Map tabStops = (Map)this.getProperty(69);
        if (tabStops != null) {
            tabStops.remove(Float.valueOf(tabStopPosition));
        }
        return this;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 33: {
                return (T1)new Leading(2, this.childElements.size() == 1 && this.childElements.get(0) instanceof Image ? 1.0f : 1.35f);
            }
            case 18: {
                return (T1)Float.valueOf(0.0f);
            }
            case 43: 
            case 46: {
                return (T1)Float.valueOf(4.0f);
            }
            case 67: {
                return (T1)Float.valueOf(50.0f);
            }
        }
        return super.getDefaultProperty(property);
    }

    public Paragraph setFirstLineIndent(float indent) {
        this.setProperty(18, Float.valueOf(indent));
        return this;
    }

    public Paragraph setFixedLeading(float leading) {
        this.setProperty(33, new Leading(1, leading));
        return this;
    }

    public Paragraph setMultipliedLeading(float leading) {
        this.setProperty(33, new Leading(2, leading));
        return this;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        if (this.selfBorder) {
            CFCAParagraphRenderer render = new CFCAParagraphRenderer(this);
            render.setSelfBorder(true);
            return render;
        }
        return new ParagraphRenderer(this);
    }

    private void addTabStopsAsProperty(List<TabStop> newTabStops) {
        TreeMap<Float, TabStop> tabStops = (TreeMap<Float, TabStop>)this.getProperty(69);
        if (tabStops == null) {
            tabStops = new TreeMap<Float, TabStop>();
            this.setProperty(69, tabStops);
        }
        for (TabStop tabStop : newTabStops) {
            tabStops.put(Float.valueOf(tabStop.getTabPosition()), tabStop);
        }
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals(role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    public void setSelfBorder(boolean selfBorder) {
        this.selfBorder = selfBorder;
    }
}

