/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css.util;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.color.WebColors;
import cfca.sadk.com.itextpdf.layout.font.Range;
import cfca.sadk.com.itextpdf.layout.font.RangeBuilder;
import cfca.sadk.com.itextpdf.layout.property.UnitValue;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CommonCssConstants;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssPropertyNormalizer;
import cfca.sadk.com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssUtils {
    private static final String[] METRIC_MEASUREMENTS = new String[]{"px", "in", "cm", "mm", "pc", "pt"};
    private static final String[] RELATIVE_MEASUREMENTS = new String[]{"%", "em", "ex", "rem"};
    private static final float EPSILON = 1.0E-6f;

    private CssUtils() {
    }

    public static String normalizeCssProperty(String str) {
        return str == null ? null : CssPropertyNormalizer.normalize(str);
    }

    public static String removeDoubleSpacesAndTrim(String str) {
        String[] parts = str.split("\\s");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static Integer parseInteger(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static Float parseFloat(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Float.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static int[] parseAspectRatio(String str) {
        int indexOfSlash = str.indexOf(47);
        try {
            int first = Integer.parseInt(str.substring(0, indexOfSlash));
            int second = Integer.parseInt(str.substring(indexOfSlash + 1));
            return new int[]{first, second};
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static float parseAbsoluteLength(String length, String defaultMetric) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(length);
        if (pos == 0) {
            if (length == null) {
                length = "null";
            }
            throw new StyledXMLParserException(MessageFormatUtil.format("The passed value (@{0}) is not a number", length));
        }
        float f = Float.parseFloat(length.substring(0, pos));
        String unit = length.substring(pos);
        if (unit.startsWith("pt") || unit.equals("") && defaultMetric.equals("pt")) {
            return f;
        }
        if (unit.startsWith("in") || unit.equals("") && defaultMetric.equals("in")) {
            return f * 72.0f;
        }
        if (unit.startsWith("cm") || unit.equals("") && defaultMetric.equals("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (unit.startsWith("q") || unit.equals("") && defaultMetric.equals("q")) {
            return f / 2.54f * 72.0f / 40.0f;
        }
        if (unit.startsWith("mm") || unit.equals("") && defaultMetric.equals("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (unit.startsWith("pc") || unit.equals("") && defaultMetric.equals("pc")) {
            return f * 12.0f;
        }
        if (unit.startsWith("px") || unit.equals("") && defaultMetric.equals("px")) {
            return f * 0.75f;
        }
        Logger logger = LoggerFactory.getLogger(CssUtils.class);
        logger.error(MessageFormatUtil.format("Unknown absolute metric length parsed \"{0}\".", unit.equals("") ? defaultMetric : unit));
        return f;
    }

    public static float parseAbsoluteLength(String length) {
        return CssUtils.parseAbsoluteLength(length, "px");
    }

    public static float parseRelativeValue(String relativeValue, float baseValue) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(relativeValue);
        if (pos == 0) {
            return 0.0f;
        }
        double f = Double.parseDouble(relativeValue.substring(0, pos));
        String unit = relativeValue.substring(pos);
        if (unit.startsWith("%")) {
            f = (double)baseValue * f / 100.0;
        } else if (unit.startsWith("em") || unit.startsWith("rem")) {
            f = (double)baseValue * f;
        } else if (unit.startsWith("ex")) {
            f = (double)baseValue * f / 2.0;
        }
        return (float)f;
    }

    public static UnitValue parseLengthValueToPt(String value, float emValue, float remValue) {
        if (CssUtils.isMetricValue(value) || CssUtils.isNumericValue(value)) {
            return new UnitValue(1, CssUtils.parseAbsoluteLength(value));
        }
        if (value != null && value.endsWith("%")) {
            return new UnitValue(2, Float.parseFloat(value.substring(0, value.length() - 1)));
        }
        if (CssUtils.isRemValue(value)) {
            return new UnitValue(1, CssUtils.parseRelativeValue(value, remValue));
        }
        if (CssUtils.isRelativeValue(value)) {
            return new UnitValue(1, CssUtils.parseRelativeValue(value, emValue));
        }
        return null;
    }

    public static float parseAbsoluteFontSize(String fontSizeValue, String defaultMetric) {
        if (null != fontSizeValue && CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.containsKey(fontSizeValue)) {
            fontSizeValue = CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.get(fontSizeValue);
        }
        try {
            return CssUtils.parseAbsoluteLength(fontSizeValue, defaultMetric);
        }
        catch (StyledXMLParserException sxpe) {
            return 0.0f;
        }
    }

    public static float parseAbsoluteFontSize(String fontSizeValue) {
        return CssUtils.parseAbsoluteFontSize(fontSizeValue, "px");
    }

    public static float parseRelativeFontSize(String relativeFontSizeValue, float baseValue) {
        if ("smaller".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue / 1.2);
        }
        if ("larger".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue * 1.2);
        }
        return CssUtils.parseRelativeValue(relativeFontSizeValue, baseValue);
    }

    public static UnitValue[] parseSpecificCornerBorderRadius(String specificBorderRadius, float emValue, float remValue) {
        if (null == specificBorderRadius) {
            return null;
        }
        UnitValue[] cornerRadii = new UnitValue[2];
        String[] props = specificBorderRadius.split("\\s+");
        cornerRadii[0] = CssUtils.parseLengthValueToPt(props[0], emValue, remValue);
        cornerRadii[1] = 2 == props.length ? CssUtils.parseLengthValueToPt(props[1], emValue, remValue) : cornerRadii[0];
        return cornerRadii;
    }

    public static float parseResolution(String resolutionStr) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(resolutionStr);
        if (pos == 0) {
            return 0.0f;
        }
        float f = Float.parseFloat(resolutionStr.substring(0, pos));
        String unit = resolutionStr.substring(pos);
        if (unit.startsWith("dpcm")) {
            f *= 2.54f;
        } else if (unit.startsWith("dppx")) {
            f *= 96.0f;
        }
        return f;
    }

    private static int determinePositionBetweenValueAndUnit(String string) {
        int pos;
        if (string == null) {
            return 0;
        }
        for (pos = 0; pos < string.length() && (string.charAt(pos) == '+' || string.charAt(pos) == '-' || string.charAt(pos) == '.' || CssUtils.isDigit(string.charAt(pos)) || CssUtils.isExponentNotation(string, pos)); ++pos) {
        }
        return pos;
    }

    public static boolean isMetricValue(String value) {
        if (value == null) {
            return false;
        }
        for (String metricPostfix : METRIC_MEASUREMENTS) {
            if (!value.endsWith(metricPostfix) || !CssUtils.isNumericValue(value.substring(0, value.length() - metricPostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRelativeValue(String value) {
        if (value == null) {
            return false;
        }
        for (String relativePostfix : RELATIVE_MEASUREMENTS) {
            if (!value.endsWith(relativePostfix) || !CssUtils.isNumericValue(value.substring(0, value.length() - relativePostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemValue(String value) {
        return value != null && value.endsWith("rem") && CssUtils.isNumericValue(value.substring(0, value.length() - "rem".length()).trim());
    }

    public static boolean isNumericValue(String value) {
        return value != null && (value.matches("^[-+]?\\d\\d*\\.\\d*$") || value.matches("^[-+]?\\d\\d*$") || value.matches("^[-+]?\\.\\d\\d*$"));
    }

    public static String extractUrl(String url) {
        String urlString;
        String str = null;
        str = url.startsWith("url") ? ((urlString = url.substring(3).trim().replace("(", "").replace(")", "").trim()).startsWith("'") && urlString.endsWith("'") ? urlString.substring(urlString.indexOf("'") + 1, urlString.lastIndexOf("'")) : (urlString.startsWith("\"") && urlString.endsWith("\"") ? urlString.substring(urlString.indexOf(34) + 1, urlString.lastIndexOf(34)) : urlString)) : url;
        return str;
    }

    public static boolean isBase64Data(String data) {
        return data.matches("^data:([^\\s]*);base64,([^\\s]*)");
    }

    public static int findNextUnescapedChar(String source, char ch, int startIndex) {
        int afterNoneEscapePos;
        int symbolPos = source.indexOf(ch, startIndex);
        if (symbolPos == -1) {
            return -1;
        }
        for (afterNoneEscapePos = symbolPos; afterNoneEscapePos > 0 && source.charAt(afterNoneEscapePos - 1) == '\\'; --afterNoneEscapePos) {
        }
        return (symbolPos - afterNoneEscapePos) % 2 == 0 ? symbolPos : CssUtils.findNextUnescapedChar(source, ch, symbolPos + 1);
    }

    public static boolean isColorProperty(String value) {
        return value.contains("rgb(") || value.contains("rgba(") || value.contains("#") || WebColors.NAMES.containsKey(value.toLowerCase()) || "transparent".equals(value);
    }

    public static boolean compareFloats(double d1, double d2) {
        return Math.abs(d1 - d2) < (double)1.0E-6f;
    }

    public static boolean compareFloats(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-6f;
    }

    public static float[] parseRgbaColor(String colorValue) {
        float[] rgbaColor = WebColors.getRGBAColor(colorValue);
        if (rgbaColor == null) {
            Logger logger = LoggerFactory.getLogger(CssUtils.class);
            logger.error(MessageFormatUtil.format("Color \"{0}\" was not parsed. It has invalid value. Defaulting to black color.", colorValue));
            rgbaColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        return rgbaColor;
    }

    public static Range parseUnicodeRange(String unicodeRange) {
        String[] ranges = unicodeRange.split(",");
        RangeBuilder builder = new RangeBuilder();
        for (String range : ranges) {
            if (CssUtils.addRange(builder, range)) continue;
            return null;
        }
        return builder.create();
    }

    private static boolean addRange(RangeBuilder builder, String range) {
        if ((range = range.trim()).matches("[uU]\\+[0-9a-fA-F?]{1,6}(-[0-9a-fA-F]{1,6})?")) {
            String[] parts = range.substring(2, range.length()).split("-");
            if (1 == parts.length) {
                if (parts[0].contains("?")) {
                    return CssUtils.addRange(builder, parts[0].replace('?', '0'), parts[0].replace('?', 'F'));
                }
                return CssUtils.addRange(builder, parts[0], parts[0]);
            }
            return CssUtils.addRange(builder, parts[0], parts[1]);
        }
        return false;
    }

    private static boolean addRange(RangeBuilder builder, String left, String right) {
        int r;
        int l = Integer.parseInt(left, 16);
        if (l > (r = Integer.parseInt(right, 16)) || r > 0x10FFFF) {
            return false;
        }
        builder.addRange(l, r);
        return true;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isExponentNotation(String s, int index) {
        return index < s.length() && s.charAt(index) == 'e' && (index + 1 < s.length() && CssUtils.isDigit(s.charAt(index + 1)) || index + 2 < s.length() && (s.charAt(index + 1) == '-' || s.charAt(index + 1) == '+') && CssUtils.isDigit(s.charAt(index + 2)));
    }
}

