/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.utils.PageRange;
import cfca.sadk.com.itextpdf.kernel.utils.PdfSplitter;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFSplitUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PDFSplitUtil.class);

    public static void splitPDF(InputStream inputStream, final OutputStream outputStream, int startPageNumber, int endPageNumber) throws SealException {
        businessLog.info("splitPDF begin...");
        PdfDocument inputPdfDoc = null;
        try {
            inputPdfDoc = new PdfDocument(new PdfReader(inputStream), false);
            ParamsCheckUtil.checkPageNum(inputPdfDoc, startPageNumber, endPageNumber);
            PageRange pageRange = new PageRange();
            pageRange.addPageSequence(startPageNumber, endPageNumber);
            PdfDocument pdfDocument = new PdfSplitter(inputPdfDoc){

                @Override
                protected PdfWriter getNextPdfWriter(PageRange documentPageRange) {
                    PdfWriter writer = new PdfWriter(outputStream);
                    return writer;
                }
            }.extractPageRange(pageRange);
            pdfDocument.close();
        }
        catch (Exception e) {
            businessLog.error("splitPDF failed:", (Throwable)e);
            throw new SealException("splitPDF failed", e);
        }
        finally {
            if (inputPdfDoc != null) {
                inputPdfDoc.close();
            }
            businessLog.info("splitPDF end...");
        }
    }
}

