/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms;

import cfca.sadk.org.bouncycastle.asn1.cms.KEKIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.AuthAttributesProvider;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSSecureReadable;
import cfca.sadk.org.bouncycastle.cms.KEKRecipient;
import cfca.sadk.org.bouncycastle.cms.KEKRecipientId;
import cfca.sadk.org.bouncycastle.cms.Recipient;
import cfca.sadk.org.bouncycastle.cms.RecipientInformation;
import cfca.sadk.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

