/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util.p12;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.P10Request;
import cfca.sadk.util.p12.P12FileFacade;
import cfca.sadk.util.p12.P12FileUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class P12FileSM2Impl
implements P12FileFacade {
    public String generateKeyPair(Mechanism algorithm, int bitLength, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2GenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] SM2Bytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileUtil.session();
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("SM2"), 256, session);
            }
            catch (PKIException e) {
                throw new PKIException("SM2 KeyPair generate failure:", e);
            }
            try {
                cert = P12FileUtil.signedMyselfCert(session, keypair, "SM2");
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair signed myself failure", e);
            }
            try {
                SM2Bytes = this.combineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair failure", e);
            }
            String base64SM2Bytes = Base64.toBase64String(SM2Bytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2GenerateKeyPair<<<<<<Finished: base64SM2Bytes=" + base64SM2Bytes);
            }
            return base64SM2Bytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("SM2GenerateKeyPair<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
    }

    public String generateP10(String base64EncryptedKeyData, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            byte[] base64p10;
            PublicKey publicKey;
            PKCS12_SM2 P10;
            if (base64EncryptedKeyData == null) {
                throw new PKIException("SM2 P10 base64EncryptedKeyData should not be null");
            }
            if (password == null) {
                throw new PKIException("SM2 P10 password should not be null");
            }
            Session session = P12FileUtil.session();
            try {
                P10 = new PKCS12_SM2();
                P10.load(Strings.toByteArray(base64EncryptedKeyData));
                P10.decrypt(password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 loading failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 Fatched PrivateKey failure", e);
            }
            try {
                publicKey = P10.getPublicCert()[0].getPublicKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 Fatched PublicKey failure", e);
            }
            String testDN = String.format("CN=certRequisition %s,O=CFCA SM2 AGENT,C=CN", P12FileUtil.generateRandom());
            X500Name subject = new X500Name(testDN);
            P10Request p10R = new P10Request(session);
            try {
                base64p10 = p10R.generatePKCS10Request(new Mechanism("sm3WithSM2Encryption"), subject, null, publicKey, privateKey, session);
            }
            catch (PKIException e) {
                throw new PKIException("SM2 P10 Generated PKCS10 failure ", e);
            }
            String base64SM2P10Text = Strings.fromByteArray(base64p10);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2GenerateP10<<<<<<Finished: base64SM2P10Text=" + base64SM2P10Text);
            }
            String string = base64SM2P10Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2GenerateP10<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2GenerateP10<<<<<<Failure", e);
            throw new PKIException("SM2GenerateP10 Failure", e);
        }
        finally {
            if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            }
        }
    }

    public String combineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12>>>>>>Running");
            buffer.append("\n base64EncryptedKeyData: ");
            buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer.append("\n base64CertData: ");
            buffer.append(SADKDebugger.dump(base64CertData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            byte[] data;
            X509Cert cert;
            PKCS12_SM2 P10;
            try {
                P10 = new PKCS12_SM2();
                P10.load(Strings.toByteArray(base64EncryptedKeyData));
                P10.decrypt(password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine loading base64EncryptedKeyData failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine Fatched PrivateKey failure", e);
            }
            try {
                cert = new X509Cert(Strings.toByteArray(base64CertData));
            }
            catch (PKIException e) {
                throw new PKIException("SM2 Combine Fatched base64CertData failure", e);
            }
            try {
                data = this.combineP12Data(cert, privateKey, password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine failure", e);
            }
            String base64SM2P12Text = Base64.toBase64String(data);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2CombineP12<<<<<<Finished: base64SM2P12Text=" + base64SM2P12Text);
            }
            String string = base64SM2P12Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12<<<<<<Failure", e);
            throw new PKIException("SM2CombineP12 Failure", e);
        }
        finally {
            if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12>>>>>>Running");
                buffer.append("\n base64EncryptedKeyData: ");
                buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
                buffer.append("\n base64CertData: ");
                buffer.append(SADKDebugger.dump(base64CertData));
                LoggerManager.exceptionLogger.error(buffer.toString());
            }
        }
    }

    public String combineP12File(X509Cert x509Cert, PrivateKey priKey, String passWord, String sm2FileName) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12File>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            buffer.append("\n fileName: ");
            buffer.append(SADKDebugger.dump(sm2FileName));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            if (sm2FileName == null) {
                throw new PKIException("SM2File fileName should not be null");
            }
            byte[] encoding = this.combineP12Data(x509Cert, priKey, passWord);
            try {
                FileHelper.write(sm2FileName, encoding);
            }
            catch (IOException e) {
                throw new PKIException("SM2File write failure with IOException", e);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2CombineP12File<<<<<<Finished: sm2FileName=" + sm2FileName);
            }
            String string = sm2FileName;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12File<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12File<<<<<<Failure", e);
            throw new PKIException("SM2CombineP12File Failure", e);
        }
        finally {
            if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12File>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                buffer.append("\n fileName: ");
                buffer.append(SADKDebugger.dump(sm2FileName));
                LoggerManager.exceptionLogger.error(buffer.toString());
            }
        }
    }

    public byte[] combineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12Data>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            if (x509Cert == null || !x509Cert.isSM2Cert()) {
                throw new PKIException("x509Cert is not SM2Type");
            }
            byte[] binaryP12Data = PKCS12_SM2.CombineSM2Data(x509Cert, priKey, password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2CombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
            }
            byte[] byArray = binaryP12Data;
            return byArray;
        }
        catch (PKIException e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12Data<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            LoggerManager.exceptionLogger.error("SM2CombineP12Data<<<<<<Failure", e);
            throw new PKIException("SM2CombineP12Data Failure", e);
        }
        finally {
            if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12Data>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                LoggerManager.exceptionLogger.error(buffer.toString());
            }
        }
    }
}

