/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.manager.CFCAX509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public abstract class CFCAX509TrustManagerFactory
extends TrustManagerFactorySpi {
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    CFCAX509TrustManagerFactory() {
    }

    @Override
    protected void engineInit(KeyStore keystore) throws KeyStoreException {
        if (keystore == null) {
            try {
                keystore = CFCAX509TrustManagerFactory.getCacertsKeyStore("trustmanager");
            }
            catch (SecurityException se) {
                if (Debugger.check.isWarnEnabled()) {
                    Debugger.check.warn("X509TrustKeyStore: skip default keystore.", (Throwable)se);
                }
            }
            catch (RuntimeException re) {
                if (Debugger.check.isWarnEnabled()) {
                    Debugger.check.warn("X509TrustKeyStore: skip default keystore.", (Throwable)re);
                }
                throw re;
            }
            catch (Exception e) {
                if (Debugger.check.isWarnEnabled()) {
                    Debugger.check.warn("X509TrustKeyStore: skip default keystore.", (Throwable)e);
                }
                throw new KeyStoreException("problem accessing trust store" + e);
            }
            catch (Error err) {
                if (Debugger.check.isWarnEnabled()) {
                    Debugger.check.warn("X509TrustKeyStore: skip default keystore.", (Throwable)err);
                }
                throw err;
            }
        }
        this.trustManager = this.getInstance(keystore);
        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(KeyStore var1) throws KeyStoreException;

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(spec);
        this.isInitialized = true;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getCacertsKeyStore(String dbgname) throws Exception {
        Map<String, String> props = CFCAX509TrustManagerFactory.loadDefaultProps();
        TrustKeystoreFile trustFile = null;
        KeyStore keystore = null;
        char[] passwd = null;
        try {
            trustFile = new TrustKeystoreFile(props);
            String defaultTrustStoreType = props.get("trustStoreType");
            String defaultTrustStoreProvider = props.get("trustStoreProvider");
            if (Debugger.check.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\ntrustStore is: ").append(trustFile.storeFileName);
                builder.append("\ntrustStore type is: ").append(defaultTrustStoreType);
                builder.append("\ntrustStore provider is: ").append(defaultTrustStoreProvider);
                Debugger.check.debug(builder.toString());
            }
            if (defaultTrustStoreType == null) {
                throw new InvalidParameterException("javax.net.ssl.trustStoreType must be not null");
            }
            if (defaultTrustStoreProvider == null) {
                throw new InvalidParameterException("javax.net.ssl.trustStoreProvider must be not null");
            }
            if (defaultTrustStoreType.length() != 0) {
                if (Debugger.check.isDebugEnabled()) {
                    String msg = String.format("init truststore trustFile=%s, trustStoreType=%s", trustFile.storeFileName, defaultTrustStoreType);
                    Debugger.check.debug(msg);
                }
                keystore = defaultTrustStoreProvider.length() != 0 ? KeyStore.getInstance(defaultTrustStoreType, defaultTrustStoreProvider) : KeyStore.getInstance(defaultTrustStoreType);
                String defaultTrustStorePassword = props.get("trustStorePasswd");
                if (defaultTrustStorePassword == null) {
                    throw new InvalidParameterException("javax.net.ssl.trustStorePassword must be not null");
                }
                if (defaultTrustStorePassword.length() != 0) {
                    passwd = defaultTrustStorePassword.toCharArray();
                    defaultTrustStorePassword = "";
                }
                keystore.load(trustFile.storeFileInputStream, passwd);
            }
            if (trustFile != null) {
                trustFile.close();
            }
            if (passwd == null) return keystore;
        }
        catch (Throwable throwable) {
            if (trustFile != null) {
                trustFile.close();
            }
            if (passwd == null) throw throwable;
            for (int i = 0; i < passwd.length; ++i) {
                passwd[i] = false;
            }
            throw throwable;
        }
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = false;
        }
        return keystore;
    }

    private static final Map<String, String> loadDefaultProps() throws Exception {
        final HashMap props = new HashMap();
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() throws Exception {
                props.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                props.put("javaHome", System.getProperty("java.home"));
                props.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                props.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                props.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return props;
            }
        });
    }

    public static final class PKIXFactory
    extends CFCAX509TrustManagerFactory {
        @Override
        X509TrustManager getInstance(KeyStore keystore) throws KeyStoreException {
            return new CFCAX509TrustManager(keystore);
        }

        @Override
        X509TrustManager getInstance(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
            if (spec == null) {
                throw new InvalidAlgorithmParameterException("Parameters must be not null");
            }
            if (!(spec instanceof CertPathTrustManagerParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be CertPathTrustManagerParameters");
            }
            CertPathParameters params = ((CertPathTrustManagerParameters)spec).getParameters();
            if (params == null) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be not null");
            }
            if (!(params instanceof PKIXBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be PKIXBuilderParameters");
            }
            return new CFCAX509TrustManager((PKIXBuilderParameters)params);
        }
    }

    private static final class TrustKeystoreFile {
        String storeFileName = null;
        FileInputStream storeFileInputStream = null;

        TrustKeystoreFile(Map<String, String> props) throws Exception {
            String sep = File.separator;
            File storeFile = null;
            this.storeFileName = props.get("trustStore");
            if (!"NONE".equals(this.storeFileName)) {
                if (this.storeFileName != null) {
                    storeFile = new File(this.storeFileName);
                    this.storeFileInputStream = TrustKeystoreFile.getFileInputStream(storeFile);
                } else {
                    String javaHome = props.get("javaHome");
                    if (javaHome != null && (this.storeFileInputStream = TrustKeystoreFile.getFileInputStream(storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "jssecacerts"))) == null) {
                        storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "cacerts");
                        this.storeFileInputStream = TrustKeystoreFile.getFileInputStream(storeFile);
                    }
                }
                this.storeFileName = this.storeFileInputStream != null ? storeFile.getPath() : "No File Available, using empty keystore.";
            }
        }

        final void close() {
            block3: {
                if (this.storeFileInputStream != null) {
                    try {
                        this.storeFileInputStream.close();
                    }
                    catch (IOException e) {
                        if (!Debugger.check.isDebugEnabled()) break block3;
                        Debugger.check.debug("storeFileInputStream closed failure", (Throwable)e);
                    }
                }
            }
        }

        private static final FileInputStream getFileInputStream(final File file) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    FileInputStream fis = null;
                    try {
                        if (file.exists()) {
                            fis = new FileInputStream(file);
                        }
                    }
                    catch (FileNotFoundException e) {
                        fis = null;
                    }
                    return fis;
                }
            });
        }
    }
}

