/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

final class HashID {
    final String name;
    final int hashId;
    final int hashLength;
    static final HashID SM3 = new HashID("SM3", 12289, 32);
    static final HashID MD2 = new HashID("MD2", 8193, 16);
    static final HashID MD5 = new HashID("MD5", 8194, 16);
    static final HashID SHA1 = new HashID("SHA1", 4097, 20);
    static final HashID SHA224 = new HashID("SHA224", 4098, 18);
    static final HashID SHA256 = new HashID("SHA256", 4099, 32);
    static final HashID SHA384 = new HashID("SHA384", 4100, 48);
    static final HashID SHA512 = new HashID("SHA512", 4101, 64);

    private HashID(String name, int hashId, int hashLength) {
        this.name = name;
        this.hashId = hashId;
        this.hashLength = hashLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hashId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashID other = (HashID)obj;
        return this.hashId == other.hashId;
    }
}

