/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class PdfSealRevoker {
    private PdfReader reader;
    private OutputStream os;
    ArrayList<String> sigNames;
    private AcroFields af;

    public PdfSealRevoker(PdfReader reader, OutputStream os) {
        this.reader = reader;
        this.os = os;
        this.af = reader.getAcroFields();
        this.sigNames = this.af.getSignatureNames();
    }

    public boolean revoke() throws DocumentException, IOException {
        boolean isOK = false;
        int sigNamesSize = this.sigNames.size();
        if (sigNamesSize == 0) {
            throw new DocumentException("No signature found in the pdf file!");
        }
        if (sigNamesSize == 1) {
            AcroFields af = this.reader.getAcroFields();
            isOK = af.removeField(af.getSignatureNames().get(0));
            PdfStamper stamper = new PdfStamper(this.reader, this.os);
            stamper.close();
        } else {
            int[] MARK_EOF = new int[]{37, 37, 69, 79, 70};
            long fileLength = this.reader.getFileLength();
            RandomAccessFileOrArray rafa = this.reader.getSafeFile();
            long p1 = 0L;
            long p2 = 0L;
            while (rafa.getFilePointer() <= fileLength - 6L) {
                int m0 = rafa.read();
                int m1 = rafa.read();
                int m2 = rafa.read();
                int m3 = rafa.read();
                int m4 = rafa.read();
                int m5 = rafa.read();
                if (m0 == MARK_EOF[0] && m1 == MARK_EOF[1] && m2 == MARK_EOF[2] && m3 == MARK_EOF[3] && m4 == MARK_EOF[4]) {
                    if (p1 == 0L) {
                        if (m5 == 13) {
                            rafa.read();
                            p1 = rafa.getFilePointer();
                            continue;
                        }
                        p1 = rafa.getFilePointer();
                        continue;
                    }
                    p2 = p1;
                    if (m5 == 13) {
                        rafa.read();
                        p1 = rafa.getFilePointer();
                        continue;
                    }
                    p1 = rafa.getFilePointer();
                    continue;
                }
                rafa.seek(rafa.getFilePointer() - 5L);
            }
            rafa.seek(0L);
            while (rafa.getFilePointer() < p2) {
                int readInt = rafa.read();
                this.os.write(readInt);
            }
            this.os.close();
            this.reader.close();
            isOK = true;
        }
        return isOK;
    }
}

