/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.core;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMap;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat13
extends CMap {
    private final int numberOfGroups;

    protected CMapFormat13(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format12.value, cmapId);
        this.numberOfGroups = this.data.readULongAsInt(CMapTable.Offset.format12nGroups.offset);
    }

    private int groupStartChar(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format13Groups.offset + groupIndex * CMapTable.Offset.format13Groups_structLength.offset + CMapTable.Offset.format13_startCharCode.offset);
    }

    private int groupEndChar(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format13Groups.offset + groupIndex * CMapTable.Offset.format13Groups_structLength.offset + CMapTable.Offset.format13_endCharCode.offset);
    }

    private int groupGlyph(int groupIndex) {
        return this.data.readULongAsInt(CMapTable.Offset.format13Groups.offset + groupIndex * CMapTable.Offset.format13Groups_structLength.offset + CMapTable.Offset.format13_glyphId.offset);
    }

    @Override
    public int glyphId(int character) {
        int group = this.data.searchULong(CMapTable.Offset.format13Groups.offset + CMapTable.Offset.format13_startCharCode.offset, CMapTable.Offset.format13Groups_structLength.offset, CMapTable.Offset.format13Groups.offset + CMapTable.Offset.format13_endCharCode.offset, CMapTable.Offset.format13Groups_structLength.offset, this.numberOfGroups, character);
        if (group == -1) {
            return 0;
        }
        return this.groupGlyph(group);
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format12Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat13> {
        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format13Length.offset)), CMap.CMapFormat.Format13, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format13Length.offset)), CMap.CMapFormat.Format13, cmapId);
        }

        @Override
        protected CMapFormat13 subBuildTable(ReadableFontData data) {
            return new CMapFormat13(data, this.cmapId());
        }
    }

    private final class CharacterIterator
    implements Iterator<Integer> {
        private int groupIndex = 0;
        private int groupEndChar;
        private boolean nextSet = false;
        private int nextChar;

        private CharacterIterator() {
            this.nextChar = CMapFormat13.this.groupStartChar(this.groupIndex);
            this.groupEndChar = CMapFormat13.this.groupEndChar(this.groupIndex);
            this.nextSet = true;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return true;
            }
            if (this.groupIndex >= CMapFormat13.this.numberOfGroups) {
                return false;
            }
            if (this.nextChar < this.groupEndChar) {
                ++this.nextChar;
                this.nextSet = true;
                return true;
            }
            ++this.groupIndex;
            if (this.groupIndex < CMapFormat13.this.numberOfGroups) {
                this.nextSet = true;
                this.nextChar = CMapFormat13.this.groupStartChar(this.groupIndex);
                this.groupEndChar = CMapFormat13.this.groupEndChar(this.groupIndex);
                return true;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

