/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.safe;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.CloseUtil;
import cfca.paperless.base.util.PwdEncryptUtil;
import cfca.paperless.base.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;

public class EncryptPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String ENCRYPTED_PREFIX = "Encrypted:";
    private static final String ENCRYPTED = "Encrypted";
    private static final char ANNOTATION_LINE_FLAG = '#';
    private Set<String> encryptedProps = Collections.emptySet();
    protected Resource[] locations;

    public void setEncryptedProps(Set<String> encryptedProps) {
        this.encryptedProps = encryptedProps;
    }

    protected String convertProperty(String propertyName, String propertyValue) {
        if (this.encryptedProps.contains(propertyName)) {
            try {
                propertyValue = EncryptPropertyPlaceholderConfigurer.decryptProperty(propertyName, propertyValue);
            }
            catch (CodeException e) {
                e.printStackTrace();
            }
        }
        return super.convertProperty(propertyName, propertyValue);
    }

    public static String decryptProperty(String propertyName, String propertyValue) throws CodeException {
        String decryptedPropValue = propertyValue;
        if (StringUtil.isNotEmpty(propertyValue) && propertyValue.startsWith(ENCRYPTED)) {
            String encryptedString = propertyValue.replaceAll(ENCRYPTED_PREFIX, "");
            decryptedPropValue = PwdEncryptUtil.decrypto(encryptedString);
        }
        return decryptedPropValue;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.postProcessBeanFactory(beanFactory);
        for (Resource location : this.locations) {
            try {
                File file = location.getFile();
                if (file.isFile()) {
                    if (file.canWrite()) {
                        this.encrypt(file);
                        continue;
                    }
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("\u65e0\u6cd5\u5199\u5165\u6587\u4ef6'" + location + "'!"));
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("File '" + location + "' is not a normal file!"));
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("File '" + location + "' is not a normal file!"));
            }
        }
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNotBlank(String str) {
        return !this.isBlank(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void encrypt(File file) {
        boolean doEncrypt;
        ArrayList<String> outputLine;
        block33: {
            outputLine = new ArrayList<String>();
            doEncrypt = false;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String line = null;
                do {
                    String[] lineParts;
                    if ((line = bufferedReader.readLine()) == null) continue;
                    if (this.isNotBlank(line) && ((line = line.trim().replace("\\", "")).length() <= 0 || line.charAt(0) != '#') && (lineParts = line.split("=")).length == 2) {
                        String key = lineParts[0];
                        String value = lineParts[1];
                        if (key != null && value != null && this.encryptedProps.contains(key) && !value.startsWith(ENCRYPTED)) {
                            try {
                                value = ENCRYPTED_PREFIX + PwdEncryptUtil.encrypto(value);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            line = key + "=" + value;
                            doEncrypt = true;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("encrypt property:" + key));
                            }
                        }
                    }
                    outputLine.add(line);
                } while (line != null);
                CloseUtil.closeQuietly(bufferedReader);
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e2) {
                this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                break block33;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CloseUtil.closeQuietly(bufferedReader);
            }
        }
        if (doEncrypt) {
            BufferedWriter bufferedWriter = null;
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile(file.getName(), null, file.getParentFile());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Create tmp file '" + tmpFile.getAbsolutePath() + "'."));
                }
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
                Iterator iterator = outputLine.iterator();
                while (iterator.hasNext()) {
                    bufferedWriter.write((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                CloseUtil.closeQuietly(bufferedWriter);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                CloseUtil.closeQuietly(bufferedWriter);
            }
            File backupFile = new File(file.getAbsoluteFile() + "_" + System.currentTimeMillis());
            if (!file.renameTo(backupFile)) {
                boolean deleteFlag;
                this.logger.error((Object)("Could not encrypt the file '" + file.getAbsoluteFile() + "'! Backup the file failed!"));
                if (tmpFile != null && !(deleteFlag = tmpFile.delete())) {
                    this.logger.warn((Object)("Delete the file '" + tmpFile.getAbsoluteFile() + " fail"));
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Backup the file '" + backupFile.getAbsolutePath() + "'."));
                }
                if (tmpFile != null) {
                    if (!tmpFile.renameTo(file)) {
                        this.logger.error((Object)("Could not encrypt the file '" + file.getAbsoluteFile() + "'! Rename the tmp file failed!"));
                        if (backupFile.renameTo(file)) {
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info((Object)"Restore the backup, success.");
                            }
                        } else {
                            this.logger.error((Object)"Restore the backup, failed!");
                        }
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Rename the file '" + tmpFile.getAbsolutePath() + "' -> '" + file.getAbsoluteFile() + "'."));
                        }
                        boolean dBackup = backupFile.delete();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Delete the backup '" + backupFile.getAbsolutePath() + "'.(" + dBackup + ")"));
                        }
                    }
                }
            }
        }
    }

    public void setLocations(Resource[] locations) {
        super.setLocations(locations);
        this.locations = locations != null ? (Resource[])locations.clone() : null;
    }

    public void setLocation(Resource location) {
        super.setLocation(location);
        this.locations = new Resource[]{location};
    }
}

