/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.operator.ContentVerifier;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.RuntimeOperatorException;
import cfca.sadk.timestamp.client.TSACertHolder;
import cfca.sadk.timestamp.client.TSADigestProviderHelper;
import java.io.OutputStream;
import java.security.PublicKey;
import org.apache.http.util.Args;

final class TSAContentVerifier
implements ContentVerifier {
    final DigestOutputStream stream;
    final AlgorithmIdentifier verifierAlgorithmIdentifier;
    final Mechanism mechanism;
    final Session session;
    final PublicKey publicKey;

    TSAContentVerifier(AlgorithmIdentifier verifierAlgorithmIdentifier, TSACertHolder holder, Session session) throws OperatorCreationException {
        SM3Digest engine;
        PublicKey publicKey;
        Args.notNull((Object)verifierAlgorithmIdentifier, (String)"verifierAlgorithmIdentifier");
        if (holder == null) {
            throw new OperatorCreationException("missing verifierCert");
        }
        try {
            publicKey = holder.getPublicKey();
        }
        catch (Exception e) {
            throw new OperatorCreationException("invalid verifierCert: " + e.getMessage(), (Throwable)e);
        }
        if (GMObjectIdentifiers.sm3WithSM2Encryption.equals((Object)verifierAlgorithmIdentifier.getAlgorithm())) {
            SM2PublicKey sm2PublicKey;
            engine = new SM3Digest();
            if (!holder.isSM2Cert()) {
                throw new OperatorCreationException("verifierAlgorithmIdentifier require SM2Cert");
            }
            try {
                sm2PublicKey = (SM2PublicKey)holder.getPublicKey();
            }
            catch (Exception e) {
                throw new OperatorCreationException("invalid SM2Cert", (Throwable)e);
            }
            byte[] zvlue = sm2PublicKey.getDefaultZ();
            engine.update(zvlue, 0, zvlue.length);
        } else {
            if (!holder.isRSACert()) {
                throw new OperatorCreationException("verifierAlgorithmIdentifier require RSACert");
            }
            engine = TSADigestProviderHelper.lookup(verifierAlgorithmIdentifier);
        }
        Mechanism mechanism = TSADigestProviderHelper.lookupMechanism(verifierAlgorithmIdentifier);
        DigestOutputStream stream = new DigestOutputStream((Digest)engine);
        this.verifierAlgorithmIdentifier = verifierAlgorithmIdentifier;
        this.mechanism = mechanism;
        this.stream = stream;
        this.publicKey = publicKey;
        this.session = session;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.verifierAlgorithmIdentifier;
    }

    public OutputStream getOutputStream() {
        if (this.stream == null) {
            throw new IllegalStateException("verifier not initialised");
        }
        return this.stream;
    }

    public boolean verify(byte[] expected) {
        boolean verifiedResult;
        byte[] hashValue = this.stream.getDigest();
        try {
            verifiedResult = this.session.verifyByHash(this.mechanism, this.publicKey, hashValue, expected);
        }
        catch (Exception e) {
            throw new RuntimeOperatorException("done verify signature failure: " + e.getMessage(), (Throwable)e);
        }
        return verifiedResult;
    }

    final class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.dig.update(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) {
            this.dig.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

