/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.api;

import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.bean.PKIStatusInfo;
import cfca.sadk.timestamp.client.bean.TSTInfo;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.x509.certificate.X509Cert;
import java.util.Date;

public final class Timestamp {
    private final PKIStatusInfo statusInfo;
    private final TSTInfo tstInfo;
    private final Date signedTime;
    private final X509Cert signedCert;
    private final MessageImprint messageImprint;
    private final byte[] timestampRequestBytes;
    private final byte[] timestampResponseBytes;

    public Timestamp(PKIStatusInfo statusInfo, TSTInfo tstInfo, Date signedTime, X509Cert signedCert, MessageImprint messageImprint, byte[] timestampRequestBytes, byte[] timestampResponseBytes) {
        this.statusInfo = statusInfo;
        this.tstInfo = tstInfo;
        this.signedTime = signedTime;
        this.signedCert = signedCert;
        this.messageImprint = messageImprint;
        this.timestampRequestBytes = timestampRequestBytes;
        this.timestampResponseBytes = timestampResponseBytes;
    }

    public final PKIStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public final TSTInfo getTstInfo() {
        return this.tstInfo;
    }

    public final String getTimestampTimeText() {
        return this.tstInfo == null ? null : this.tstInfo.getTimestampText();
    }

    public final Date getTimestampTime() {
        return this.tstInfo == null ? null : this.tstInfo.getTimestampTime();
    }

    public final X509Cert getTimestampCert() {
        return this.signedCert;
    }

    public final MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public final byte[] getTimestampRequestBytes() {
        return this.timestampRequestBytes;
    }

    public final byte[] getTimestampResponseBytes() {
        return this.timestampResponseBytes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nTimestamp [statusInfo");
        builder.append("\n\t statusInfo=");
        builder.append(this.statusInfo);
        builder.append("\n\t tstInfo=");
        builder.append(this.tstInfo);
        builder.append("\n\t signedTime=");
        builder.append(this.signedTime);
        builder.append("\n\t signedCert=");
        builder.append(this.signedCert);
        builder.append("\n\t messageImprint=");
        builder.append(this.messageImprint);
        builder.append("\n\t timestampRequestBytes=");
        if (this.timestampRequestBytes != null) {
            builder.append("0x");
            builder.append(TscStrings.toHexString(this.timestampRequestBytes));
        }
        builder.append("\n\t timestampResponseBytes=");
        if (this.timestampResponseBytes != null) {
            builder.append("0x");
            builder.append(TscStrings.toHexString(this.timestampResponseBytes));
        }
        builder.append("]");
        return builder.toString();
    }
}

