/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conn;

import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.utils.TscStrings;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.util.Args;

public final class HTTPRequestResult {
    private final String requestRecord;
    private final StatusLine statusLine;
    private final Header[] headers;
    private final byte[] content;

    public HTTPRequestResult(String requestRecord, StatusLine statusLine, Header[] headers, byte[] content) {
        this.requestRecord = (String)Args.notNull((Object)requestRecord, (String)"requestRecord");
        this.statusLine = (StatusLine)Args.notNull((Object)statusLine, (String)"statusLine");
        this.headers = (Header[])Args.notNull((Object)headers, (String)"headers");
        this.content = (byte[])Args.notNull((Object)content, (String)"content");
    }

    public String getRequestRecord() {
        return this.requestRecord;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentText() {
        String contextText = null;
        if (this.statusLine == null) {
            contextText = "null";
        } else if (this.statusLine.getStatusCode() == 200) {
            contextText = this.content == null ? "" : TscStrings.toBase64String(this.content);
        } else {
            try {
                contextText = new String(this.content, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                TscLogging.ERROR_LOGGER.error("content to text failed", (Throwable)e);
            }
        }
        return contextText;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(2048);
        String name = null;
        String value = null;
        if (this.headers != null) {
            for (Header header : this.headers) {
                name = header.getName();
                value = header.getValue();
                builder.append(name).append(": ").append(value).append("\r\n");
            }
            if (this.statusLine != null) {
                int status = this.statusLine.getStatusCode();
                if (status == 200) {
                    builder.append(this.content == null ? "none" : TscStrings.toBase64String(this.content)).append("\r\n");
                } else {
                    try {
                        builder.append(new String(this.content, "UTF8")).append("\r\n");
                    }
                    catch (UnsupportedEncodingException e) {
                        TscLogging.ERROR_LOGGER.error("content to text failed", (Throwable)e);
                    }
                }
            }
        }
        return builder.toString();
    }
}

