/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.timestamp.client.logging.TscLogging;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

class TscConnectionSocketFactory
implements ConnectionSocketFactory {
    final long loggingWarnThresholdTime;

    TscConnectionSocketFactory(long loggingWarnThresholdTime) {
        this.loggingWarnThresholdTime = loggingWarnThresholdTime;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return new Socket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock;
        Args.notNull((Object)socket, (String)"socket");
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        String fepUUID = (String)context.getAttribute("CFCA-TSC-UUID");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        } else {
            sock.bind(new InetSocketAddress(0));
        }
        context.setAttribute("ID_TSC_LOCAL_PORT", (Object)sock.getLocalPort());
        SocketAddress localsa = sock.getLocalSocketAddress();
        long startTime = System.currentTimeMillis();
        long connectTime = 0L;
        try {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} socket assignLocalPort={} connet to {} starting", new Object[]{fepUUID, sock.getLocalPort(), remoteAddress});
            sock.connect(remoteAddress, connectTimeout);
            localsa = sock.getLocalSocketAddress();
            connectTime = System.currentTimeMillis() - startTime;
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} socket {} connet to {} successfully: tcp-connectTime={}ms[timeout={}]", new Object[]{fepUUID, localsa, remoteAddress, connectTime, connectTimeout});
            if (connectTime > this.getLoggingWarnThresholdTime()) {
                TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} socket {} connet to {} successfully: tcp-connectTime={}ms[timeout={}], warningThresholdTime={}ms", new Object[]{fepUUID, localsa, remoteAddress, connectTime, connectTimeout, this.getLoggingWarnThresholdTime()});
            }
        }
        catch (ConnectException e) {
            int localPort = sock.getLocalPort();
            context.setAttribute("ID_TSC_LOCAL_PORT", (Object)localPort);
            connectTime = System.currentTimeMillis() - startTime;
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} socket {} connet to {} failed: tcp-connectTime={}ms[timeout={}]", new Object[]{fepUUID, localsa, remoteAddress, connectTime, connectTimeout, e});
            this.closeSocket(sock);
            if (localPort != 0) {
                throw new ConnectException(String.format("CFCA-TSC-UUID=%s withLocalPort=%s: %s", fepUUID, localPort, e.getMessage()));
            }
            throw e;
        }
        catch (IOException e) {
            connectTime = System.currentTimeMillis() - startTime;
            TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} socket {} connet to {} failed: tcp-connectTime={}ms[timeout={}]", new Object[]{fepUUID, localsa, remoteAddress, connectTime, connectTimeout, e});
            this.closeSocket(sock);
            throw e;
        }
        return sock;
    }

    final void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    final long getLoggingWarnThresholdTime() {
        return this.loggingWarnThresholdTime;
    }
}

