/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.cell;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.FontUnderline;

public enum Underline {
    NORMAL(0, FontUnderline.NONE),
    UNDERLINE(1, FontUnderline.SINGLE);

    @JsonValue
    private final Integer lsValue;
    private final FontUnderline poiValue;
    private static final Map<FontUnderline, Underline> TYPES;

    public static Underline of(FontUnderline fontUnderline) {
        Underline underline = TYPES.get(fontUnderline);
        if (underline == null) {
            return NORMAL;
        }
        return underline;
    }

    @Generated
    private Underline(Integer lsValue, FontUnderline poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    @Generated
    public FontUnderline getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(Underline.values()).collect(Collectors.toMap(Underline::getPoiValue, Function.identity()));
    }
}

