/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.sheet;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.autoffice.luckysheet.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.BorderStyle;

public enum BorderStyleType {
    NONE(0, "None", BorderStyle.NONE),
    THIN(1, "Thin", BorderStyle.THIN),
    HAIR(2, "Hair", BorderStyle.HAIR),
    DOTTED(3, "Dotted", BorderStyle.DOTTED),
    DASHED(4, "Dashed", BorderStyle.DASHED),
    DASH_DOT(5, "DashDot", BorderStyle.DASH_DOT),
    DASH_DOT_DOT(6, "DashDotDot", BorderStyle.DASH_DOT_DOT),
    DOUBLE(7, "Double", BorderStyle.DOUBLE),
    MEDIUM(8, "Medium", BorderStyle.MEDIUM),
    MEDIUM_DASHED(9, "MediumDashed", BorderStyle.MEDIUM_DASHED),
    MEDIUM_DASH_DOT(10, "MediumDashDot", BorderStyle.MEDIUM_DASH_DOT),
    MEDIUM_DASH_DOT_DOT(11, "MediumDashDotDot", BorderStyle.MEDIUM_DASH_DOT_DOT),
    SLANTED_DASH_DOT(12, "SlantedDashDot", BorderStyle.SLANTED_DASH_DOT),
    THICK(13, "Thick", BorderStyle.THICK);

    @JsonValue
    private final Integer lsValue;
    private final String name;
    private final BorderStyle poiValue;
    private static final Map<BorderStyle, BorderStyleType> TYPES;

    public static BorderStyleType of(BorderStyle borderStyle) {
        BorderStyleType borderStyleType = TYPES.get(borderStyle);
        return Util.requireNonNullElse(borderStyleType, THIN);
    }

    @Generated
    private BorderStyleType(Integer lsValue, String name, BorderStyle poiValue) {
        this.lsValue = lsValue;
        this.name = name;
        this.poiValue = poiValue;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BorderStyle getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(BorderStyleType.values()).collect(Collectors.toMap(BorderStyleType::getPoiValue, Function.identity()));
    }
}

