/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.utils;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3DigestKit;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.timestamp.client.env.DefaultSessionLib;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.util.Base64;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.util.Args;

public final class TscPasswordTool {
    private static final int PASSWORD_ENCRYPT_MIN_LEN = 16;
    private static final String PASSWORD_ENCRYPT_PREFIX = "ENCRYPT@";

    public static final String readPassword(String password, String name) throws TSAException {
        String plainPassword = null;
        if (password != null && password.startsWith(PASSWORD_ENCRYPT_PREFIX)) {
            try {
                plainPassword = TscPasswordTool.decryptPassword(password.substring(PASSWORD_ENCRYPT_PREFIX.length()));
            }
            catch (Exception e) {
                throw new TSAException(name + " restored [decryptPassword]  failure: " + password, (Throwable)e);
            }
        } else {
            plainPassword = password;
        }
        return plainPassword;
    }

    public static final String encryptPassword(String plainPassword) throws Exception {
        Args.notNull((Object)plainPassword, (String)"plainPassword");
        byte[] iv = SecureRandoms.getInstance().genBytes(16);
        IvAndKey ik = TscPasswordTool.kdf();
        byte[] password = TscStrings.getUTF8Bytes(plainPassword);
        byte[] enBytes = DefaultSessionLib.SESSION.encrypt(new Mechanism("SM4/CBC/PKCS7Padding", (Object)ik.iv(iv)), ik.key(), password);
        byte[] ouBytes = new byte[iv.length + enBytes.length];
        System.arraycopy(iv, 0, ouBytes, 0, iv.length);
        System.arraycopy(enBytes, 0, ouBytes, iv.length, enBytes.length);
        return TscStrings.toBase64String((byte[])ouBytes.clone());
    }

    public static final String decryptPassword(String base64EncryptPassword) throws Exception {
        Args.notNull((Object)base64EncryptPassword, (String)"base64EncryptPassword");
        if (base64EncryptPassword.length() < 16) {
            throw new Exception("the length of encrepted password must be more than 16!");
        }
        byte[] data = Base64.decode((String)base64EncryptPassword);
        byte[] iv = Arrays.copyOfRange(data, 0, 16);
        IvAndKey ik = TscPasswordTool.kdf();
        byte[] encryptBytes = Arrays.copyOfRange(data, 16, data.length);
        byte[] passowrd = DefaultSessionLib.SESSION.decrypt(new Mechanism("SM4/CBC/PKCS7Padding", (Object)ik.iv(iv)), ik.key(), encryptBytes);
        return TscStrings.toUTF8String((byte[])passowrd.clone());
    }

    static final IvAndKey kdf() throws Exception {
        byte[] message = "OCSP@+VSEXAMLONGINX%He&&LONG".getBytes("utf8");
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3DigestKit sm3 = new SM3DigestKit();
        sm3.update(message, 0, message.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return new IvAndKey(hash);
    }

    static final class IvAndKey {
        final byte[] iv = new byte[16];
        final byte[] kx = new byte[16];

        IvAndKey(byte[] hash) {
            System.arraycopy(hash, 0, this.iv, 0, this.iv.length);
            System.arraycopy(hash, 16, this.kx, 0, this.kx.length);
        }

        private final CBCParam iv(byte[] iv) {
            byte[] dx = (byte[])iv.clone();
            for (int i = 0; i < iv.length; ++i) {
                int n = i;
                dx[n] = (byte)(dx[n] ^ this.iv[i]);
            }
            return new CBCParam(dx);
        }

        private final Key key() {
            return new SecretKeySpec(this.kx, "SM4");
        }
    }
}

