/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.mapper;

import io.github.autoffice.luckysheet.mapper.CellMapperToExcel;
import io.github.autoffice.luckysheet.mapper.ImageMapperToExcel;
import io.github.autoffice.luckysheet.mapper.LuckySheetFactory;
import io.github.autoffice.luckysheet.mapper.PoiFactory;
import io.github.autoffice.luckysheet.model.cell.CellData;
import io.github.autoffice.luckysheet.model.cell.MergeCell;
import io.github.autoffice.luckysheet.model.sheet.BoolStatus;
import io.github.autoffice.luckysheet.model.sheet.Border;
import io.github.autoffice.luckysheet.model.sheet.BorderRangeType;
import io.github.autoffice.luckysheet.model.sheet.BorderStyleType;
import io.github.autoffice.luckysheet.model.sheet.Frozen;
import io.github.autoffice.luckysheet.model.sheet.LuckySheet;
import io.github.autoffice.luckysheet.model.sheet.PageMargin;
import io.github.autoffice.luckysheet.model.sheet.Range;
import io.github.autoffice.luckysheet.util.NumberUtil;
import io.github.autoffice.luckysheet.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.PaperSize;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class SheetMapperToExcel {
    public static final Short LUCKY_SHEET_DEFAULT_ROW_HEIGHT_IN_PIXEL = 19;
    public static final Short LUCY_SHEET_DEFAULT_COL_WIDTH_IN_PIXEL = 73;

    public static void mapToSheet(LuckySheet luckySheet, XSSFSheet sheet) {
        SheetMapperToExcel.mapDefaultRowHeight(luckySheet.getDefaultRowHeight(), sheet);
        SheetMapperToExcel.mapDefaultColumnWidth(luckySheet.getDefaultColWidth(), sheet);
        for (CellData cellData : luckySheet.getCelldata()) {
            XSSFCell cell = PoiFactory.createOrGetCell(sheet, cellData.getR(), cellData.getC());
            CellMapperToExcel.mapToCell(cellData, cell);
        }
        SheetMapperToExcel.mapSheetStatus(luckySheet.getStatus(), sheet);
        SheetMapperToExcel.mapSheetHidden(luckySheet.getHide(), sheet);
        SheetMapperToExcel.mapMergeCell(luckySheet.getConfig().getMerge(), sheet);
        SheetMapperToExcel.mapRowHeight(luckySheet.getConfig().getRowlen(), sheet);
        SheetMapperToExcel.mapColumnWith(luckySheet.getConfig().getColumnlen(), sheet);
        SheetMapperToExcel.mapRowHidden(luckySheet.getConfig().getRowhidden(), sheet);
        SheetMapperToExcel.mapColumnHidden(luckySheet.getConfig().getColhidden(), sheet);
        SheetMapperToExcel.mapBorder(luckySheet.getConfig().getBorderInfo(), sheet);
        SheetMapperToExcel.mapGridLines(luckySheet.getShowGridLines(), sheet);
        SheetMapperToExcel.mapFrozen(luckySheet.getFrozen(), sheet);
        SheetMapperToExcel.mapPageMargin(luckySheet.getPageMargin(), sheet);
        ImageMapperToExcel.mapToSheet(luckySheet.getImages(), sheet);
    }

    private static void mapPageMargin(PageMargin pageMargin, XSSFSheet sheet) {
        XSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setPaperSize(PaperSize.A4_PAPER);
        printSetup.setLandscape(pageMargin.getLandscape().booleanValue());
        printSetup.setScale(pageMargin.getScale());
        sheet.setMargin((short)0, pageMargin.getLeft().doubleValue());
        sheet.setMargin((short)1, pageMargin.getRight().doubleValue());
        sheet.setMargin((short)2, pageMargin.getTop().doubleValue());
        sheet.setMargin((short)3, pageMargin.getBottom().doubleValue());
    }

    private static void mapFrozen(Frozen frozen, XSSFSheet sheet) {
        if (frozen == null) {
            return;
        }
        switch (frozen.getType()) {
            case ROW: {
                sheet.createFreezePane(0, 1);
                break;
            }
            case COLUMN: {
                sheet.createFreezePane(1, 0);
                break;
            }
            case BOTH: {
                sheet.createFreezePane(1, 1);
                break;
            }
            case RANGE_ROW: {
                sheet.createFreezePane(0, frozen.getRange().getRow_focus());
                break;
            }
            case RANGE_COLUMN: {
                sheet.createFreezePane(frozen.getRange().getColumn_focus(), 0);
                break;
            }
            case RANGE_BOTH: {
                sheet.createFreezePane(frozen.getRange().getColumn_focus(), frozen.getRange().getRow_focus());
                break;
            }
            case CANCEL: {
                sheet.createFreezePane(0, 0);
                break;
            }
        }
    }

    private static void mapGridLines(BoolStatus showGridLines, XSSFSheet sheet) {
        if (showGridLines == null) {
            return;
        }
        sheet.setDisplayGridlines(showGridLines.isPoiValue());
    }

    private static void mapBorder(List<Border> borderList, XSSFSheet sheet) {
        if (CollectionUtils.isEmpty(borderList)) {
            return;
        }
        ArrayList<Border> borderListTmp = new ArrayList<Border>();
        for (Border border : borderList) {
            if (border.getRangeType() != BorderRangeType.RANGE) continue;
            borderListTmp.addAll(SheetMapperToExcel.mapRangeBorderToCellBorder(border));
        }
        borderList.addAll(borderListTmp);
        for (Border border : borderList) {
            if (border.getRangeType() != BorderRangeType.CELL || !LuckySheetFactory.hasBorderStyle(border)) continue;
            XSSFCell cell = PoiFactory.createOrGetCell(sheet, border.getValue().getRow_index(), border.getValue().getCol_index());
            SheetMapperToExcel.mapCellBorder(cell, border.getValue());
        }
    }

    private static List<Border> mapRangeBorderToCellBorder(Border border) {
        ArrayList<Border> borders = new ArrayList<Border>();
        if (CollectionUtils.isEmpty(border.getRange())) {
            return borders;
        }
        block12: for (Range range : border.getRange()) {
            if (CollectionUtils.size(range.getRow()) != 2 || CollectionUtils.size(range.getColumn()) != 2) continue;
            Integer rowTop = range.getRow().get(0);
            Integer rowBottom = range.getRow().get(1);
            Integer colLeft = range.getColumn().get(0);
            Integer colRight = range.getColumn().get(1);
            Border.Style borderStyle = LuckySheetFactory.createBorderStyle(border);
            switch (border.getBorderType()) {
                case LEFT: {
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        Border borderTmp = LuckySheetFactory.createBorder(row, colLeft);
                        borderTmp.getValue().setL(borderStyle);
                        borders.add(borderTmp);
                    }
                    continue block12;
                }
                case RIGHT: {
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        Border borderTmp = LuckySheetFactory.createBorder(row, colRight);
                        borderTmp.getValue().setR(borderStyle);
                        borders.add(borderTmp);
                    }
                    continue block12;
                }
                case TOP: {
                    int col;
                    for (col = colLeft.intValue(); col <= colRight; ++col) {
                        Border borderTmp = LuckySheetFactory.createBorder(rowTop, col);
                        borderTmp.getValue().setT(borderStyle);
                        borders.add(borderTmp);
                    }
                    continue block12;
                }
                case BOTTOM: {
                    int col;
                    for (col = colLeft.intValue(); col <= colRight; ++col) {
                        Border borderTmp = LuckySheetFactory.createBorder(rowBottom, col);
                        borderTmp.getValue().setB(borderStyle);
                        borders.add(borderTmp);
                    }
                    continue block12;
                }
                case ALL: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            borderTmp.getValue().setL(borderStyle);
                            borderTmp.getValue().setR(borderStyle);
                            borderTmp.getValue().setT(borderStyle);
                            borderTmp.getValue().setB(borderStyle);
                            borders.add(borderTmp);
                        }
                    }
                    continue block12;
                }
                case OUTSIDE: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            if (row == rowTop) {
                                borderTmp.getValue().setT(borderStyle);
                            }
                            if (row == rowBottom) {
                                borderTmp.getValue().setB(borderStyle);
                            }
                            if (col == colLeft) {
                                borderTmp.getValue().setL(borderStyle);
                            }
                            if (col == colRight) {
                                borderTmp.getValue().setR(borderStyle);
                            }
                            if (!LuckySheetFactory.hasBorderStyle(borderTmp)) continue;
                            borders.add(borderTmp);
                        }
                    }
                    continue block12;
                }
                case INSIDE: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            borderTmp.getValue().setT(borderStyle);
                            borderTmp.getValue().setB(borderStyle);
                            borderTmp.getValue().setL(borderStyle);
                            borderTmp.getValue().setR(borderStyle);
                            if (row == rowTop) {
                                borderTmp.getValue().setT(null);
                            }
                            if (row == rowBottom) {
                                borderTmp.getValue().setB(null);
                            }
                            if (col == colLeft) {
                                borderTmp.getValue().setL(null);
                            }
                            if (col == colRight) {
                                borderTmp.getValue().setR(null);
                            }
                            if (!LuckySheetFactory.hasBorderStyle(borderTmp)) continue;
                            borders.add(borderTmp);
                        }
                    }
                    continue block12;
                }
                case HORIZONTAL: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            if (row != rowBottom) {
                                borderTmp.getValue().setB(borderStyle);
                            }
                            if (!LuckySheetFactory.hasBorderStyle(borderTmp)) continue;
                            borders.add(borderTmp);
                        }
                    }
                    continue block12;
                }
                case VERTICAL: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            if (col != colRight) {
                                borderTmp.getValue().setR(borderStyle);
                            }
                            if (!LuckySheetFactory.hasBorderStyle(borderTmp)) continue;
                            borders.add(borderTmp);
                        }
                    }
                    continue block12;
                }
                case NONE: {
                    Border borderTmp;
                    int row;
                    for (row = rowTop.intValue(); row <= rowBottom; ++row) {
                        for (int col = colLeft.intValue(); col <= colRight; ++col) {
                            borderTmp = LuckySheetFactory.createBorder(row, col);
                            borderStyle.setStyle(BorderStyleType.NONE);
                            borderTmp.getValue().setL(borderStyle);
                            borderTmp.getValue().setR(borderStyle);
                            borderTmp.getValue().setT(borderStyle);
                            borderTmp.getValue().setB(borderStyle);
                            borders.add(borderTmp);
                        }
                    }
                    break;
                }
            }
        }
        return borders;
    }

    private static void mapCellBorder(XSSFCell cell, Border.Value value) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        if (value.getT() != null) {
            cellStyle.setBorderTop(value.getT().getStyle().getPoiValue());
            cellStyle.setTopBorderColor(new XSSFColor(NumberUtil.colorStringToRgb(value.getT().getColor()), null));
        }
        if (value.getR() != null) {
            cellStyle.setBorderRight(value.getR().getStyle().getPoiValue());
            cellStyle.setRightBorderColor(new XSSFColor(NumberUtil.colorStringToRgb(value.getR().getColor()), null));
        }
        if (value.getB() != null) {
            cellStyle.setBorderBottom(value.getB().getStyle().getPoiValue());
            cellStyle.setBottomBorderColor(new XSSFColor(NumberUtil.colorStringToRgb(value.getB().getColor()), null));
        }
        if (value.getL() != null) {
            cellStyle.setBorderLeft(value.getL().getStyle().getPoiValue());
            cellStyle.setLeftBorderColor(new XSSFColor(NumberUtil.colorStringToRgb(value.getL().getColor()), null));
        }
    }

    private static void mapColumnHidden(Map<Integer, Integer> colhidden, XSSFSheet sheet) {
        if (MapUtils.isEmpty(colhidden)) {
            return;
        }
        for (Integer col : colhidden.keySet()) {
            sheet.setColumnHidden(col.intValue(), true);
        }
    }

    private static void mapRowHidden(Map<Integer, Integer> rowhidden, XSSFSheet sheet) {
        if (MapUtils.isEmpty(rowhidden)) {
            return;
        }
        for (Integer rowNum : rowhidden.keySet()) {
            XSSFRow row = PoiFactory.createOrGetRow(sheet, rowNum);
            row.setZeroHeight(true);
        }
    }

    private static void mapColumnWith(Map<Integer, Integer> columnlen, XSSFSheet sheet) {
        if (MapUtils.isEmpty(columnlen)) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : columnlen.entrySet()) {
            Integer colNum = entry.getKey();
            Integer width = entry.getValue();
            sheet.setColumnWidth(colNum.intValue(), NumberUtil.pixel2PoiColWidth(width));
        }
    }

    private static void mapRowHeight(Map<Integer, Integer> rowlen, XSSFSheet sheet) {
        if (MapUtils.isEmpty(rowlen)) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : rowlen.entrySet()) {
            Integer rowNum = entry.getKey();
            Integer height = entry.getValue();
            XSSFRow row = PoiFactory.createOrGetRow(sheet, rowNum);
            row.setHeight((short)NumberUtil.pixel2Twips(height));
        }
    }

    private static void mapMergeCell(Map<String, MergeCell> merge, XSSFSheet sheet) {
        if (MapUtils.isEmpty(merge)) {
            return;
        }
        for (MergeCell value : merge.values()) {
            CellRangeAddress cellAddresses = new CellRangeAddress(value.getR().intValue(), value.getR() + value.getRs() - 1, value.getC().intValue(), value.getC() + value.getCs() - 1);
            sheet.addMergedRegion(cellAddresses);
        }
    }

    private static void mapSheetHidden(BoolStatus hide, XSSFSheet sheet) {
        if (hide == null) {
            return;
        }
        sheet.getWorkbook().setSheetHidden(sheet.getWorkbook().getSheetIndex((Sheet)sheet), hide.isPoiValue());
    }

    private static void mapSheetStatus(BoolStatus status, XSSFSheet sheet) {
        if (status == null) {
            return;
        }
        sheet.setSelected(status.isPoiValue());
    }

    private static void mapDefaultColumnWidth(Short defaultColumnWidth, XSSFSheet sheet) {
        sheet.setDefaultColumnWidth(NumberUtil.pixel2CharacterLen(Util.requireNonNullElse(defaultColumnWidth, LUCY_SHEET_DEFAULT_COL_WIDTH_IN_PIXEL).shortValue()));
    }

    private static void mapDefaultRowHeight(Short defaultRowHeight, XSSFSheet sheet) {
        sheet.setDefaultRowHeight((short)NumberUtil.pixel2Twips(Util.requireNonNullElse(defaultRowHeight, LUCKY_SHEET_DEFAULT_ROW_HEIGHT_IN_PIXEL).shortValue()));
    }
}

