/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.sun.security.ssl.manager.CFCAX509KeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;

abstract class CFCAX509KeyManagerFactory
extends KeyManagerFactorySpi {
    X509ExtendedKeyManager keyManager;
    boolean isInitialized;

    CFCAX509KeyManagerFactory() {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("KeyManagerFactoryImpl is not initialized");
        }
        return new KeyManager[]{this.keyManager};
    }

    public static final class CFCAX509Factory
    extends CFCAX509KeyManagerFactory {
        @Override
        protected void engineInit(KeyStore keystore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keystore == null) {
                this.keyManager = new CFCAX509KeyManager(Collections.<KeyStore.Builder>emptyList());
            } else {
                try {
                    KeyStore.Builder builder = KeyStore.Builder.newInstance(keystore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(password));
                    this.keyManager = new CFCAX509KeyManager(builder);
                }
                catch (RuntimeException e) {
                    throw new KeyStoreException("initialization failed", e);
                }
            }
            this.isInitialized = true;
        }

        @Override
        protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
            if (!(params instanceof KeyStoreBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
            }
            List<KeyStore.Builder> builders = ((KeyStoreBuilderParameters)params).getParameters();
            this.keyManager = new CFCAX509KeyManager(builders);
            this.isInitialized = true;
        }
    }
}

