/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.annot;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import java.util.HashSet;

public class PdfWidgetAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 9013938639824707088L;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int VISIBLE = 4;
    private HashSet<PdfName> widgetEntries = new HashSet();

    public PdfWidgetAnnotation(Rectangle rect) {
        super(rect);
        this.widgetEntries.add(PdfName.Subtype);
        this.widgetEntries.add(PdfName.Type);
        this.widgetEntries.add(PdfName.Rect);
        this.widgetEntries.add(PdfName.Contents);
        this.widgetEntries.add(PdfName.P);
        this.widgetEntries.add(PdfName.NM);
        this.widgetEntries.add(PdfName.M);
        this.widgetEntries.add(PdfName.F);
        this.widgetEntries.add(PdfName.AP);
        this.widgetEntries.add(PdfName.AS);
        this.widgetEntries.add(PdfName.Border);
        this.widgetEntries.add(PdfName.C);
        this.widgetEntries.add(PdfName.StructParent);
        this.widgetEntries.add(PdfName.OC);
        this.widgetEntries.add(PdfName.H);
        this.widgetEntries.add(PdfName.MK);
        this.widgetEntries.add(PdfName.A);
        this.widgetEntries.add(PdfName.AA);
        this.widgetEntries.add(PdfName.BS);
    }

    public PdfWidgetAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
        this.widgetEntries.add(PdfName.Subtype);
        this.widgetEntries.add(PdfName.Type);
        this.widgetEntries.add(PdfName.Rect);
        this.widgetEntries.add(PdfName.Contents);
        this.widgetEntries.add(PdfName.P);
        this.widgetEntries.add(PdfName.NM);
        this.widgetEntries.add(PdfName.M);
        this.widgetEntries.add(PdfName.F);
        this.widgetEntries.add(PdfName.AP);
        this.widgetEntries.add(PdfName.AS);
        this.widgetEntries.add(PdfName.Border);
        this.widgetEntries.add(PdfName.C);
        this.widgetEntries.add(PdfName.StructParent);
        this.widgetEntries.add(PdfName.OC);
        this.widgetEntries.add(PdfName.H);
        this.widgetEntries.add(PdfName.MK);
        this.widgetEntries.add(PdfName.A);
        this.widgetEntries.add(PdfName.AA);
        this.widgetEntries.add(PdfName.BS);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Widget;
    }

    public PdfWidgetAnnotation setParent(PdfObject parent) {
        return (PdfWidgetAnnotation)this.put(PdfName.Parent, parent);
    }

    public PdfWidgetAnnotation setHighlightMode(PdfName mode) {
        return (PdfWidgetAnnotation)this.put(PdfName.H, mode);
    }

    public PdfName getHighlightMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.H);
    }

    public void releaseFormFieldFromWidgetAnnotation() {
        PdfDictionary annotDict = (PdfDictionary)this.getPdfObject();
        for (PdfName entry : this.widgetEntries) {
            annotDict.remove(entry);
        }
        PdfDictionary parent = annotDict.getAsDictionary(PdfName.Parent);
        if (parent != null && annotDict.size() == 1) {
            PdfArray kids = parent.getAsArray(PdfName.Kids);
            kids.remove(annotDict.getIndirectReference());
            if (kids.size() == 0) {
                parent.remove(PdfName.Kids);
            }
        }
    }

    public PdfWidgetAnnotation setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(36));
                break;
            }
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(4));
            }
        }
        return this;
    }
}

