/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.table.opentype.AlternateSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ChainContextSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ContextSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.LigatureSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.MultipleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ReverseChainSingleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.SingleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.com.google.typography.font.sfntly.table.opentype.component.GsubLookupType;

public class ExtensionSubst
extends SubstSubtable {
    private static final int LOOKUP_TYPE_OFFSET = 0;
    private static final int LOOKUP_OFFSET_OFFSET = 2;
    final GsubLookupType lookupType;
    final int lookupOffset;

    ExtensionSubst(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        if (this.format != 1) {
            throw new IllegalArgumentException("illegal extension format " + this.format);
        }
        this.lookupType = GsubLookupType.forTypeNum(data.readUShort(base + this.headerSize() + 0));
        this.lookupOffset = data.readULongAsInt(base + this.headerSize() + 2);
    }

    public GsubLookupType lookupType() {
        return this.lookupType;
    }

    public SubstSubtable subTable() {
        ReadableFontData data = this.data.slice(this.lookupOffset);
        switch (this.lookupType) {
            case GSUB_LIGATURE: {
                return new LigatureSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_SINGLE: {
                return new SingleSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_MULTIPLE: {
                return new MultipleSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_ALTERNATE: {
                return new AlternateSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_CONTEXTUAL: {
                return new ContextSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_CHAINING_CONTEXTUAL: {
                return new ChainContextSubst(data, 0, this.dataIsCanonical);
            }
            case GSUB_REVERSE_CHAINING_CONTEXTUAL_SINGLE: {
                return new ReverseChainSingleSubst(data, 0, this.dataIsCanonical);
            }
        }
        throw new IllegalArgumentException("LookupType is " + this.lookupType);
    }

    public static class Builder
    extends SubstSubtable.Builder<SubstSubtable> {
        protected Builder() {
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data, dataIsCanonical);
        }

        @Override
        public SubstSubtable subBuildTable(ReadableFontData data) {
            return null;
        }
    }
}

