/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.convert;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.convert.DefaultConverter;
import cfca.sadk.ofd.base.ofd.OFDParser;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ConvertUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ConvertUtil.class);

    public static byte[] convertToPdf(byte[] ofdDatas) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        long start = System.currentTimeMillis();
        try {
            OFDParser parser = new OFDParser();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DefaultConverter converter = new DefaultConverter(output);
            parser.parseFile(ofdDatas, converter);
            parser.clear();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            businessLog.error("convertToPdf failed", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("convertToPdf costTime=" + (end - start) + "ms");
        }
    }

    public static void convertToPdf(byte[] ofdDatas, OutputStream output) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        if (null == output) {
            throw new IllegalArgumentException("output is null!");
        }
        long start = System.currentTimeMillis();
        try {
            OFDParser parser = new OFDParser();
            DefaultConverter converter = new DefaultConverter(output);
            parser.parseFile(ofdDatas, converter);
            parser.clear();
        }
        catch (Exception e) {
            businessLog.error("convertToPdf failed", (Throwable)e);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("convertToPdf costTime=" + (end - start) + "ms");
        }
    }
}

