/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font.otf;

import cfca.sadk.com.itextpdf.io.font.otf.Glyph;
import cfca.sadk.com.itextpdf.io.font.otf.GlyphLine;
import cfca.sadk.com.itextpdf.io.font.otf.GposAnchor;
import cfca.sadk.com.itextpdf.io.font.otf.OpenTableLookup;
import cfca.sadk.com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import cfca.sadk.com.itextpdf.io.font.otf.OtfMarkRecord;
import cfca.sadk.com.itextpdf.io.font.otf.OtfReadCommon;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GposLookupType6
extends OpenTableLookup {
    private static final long serialVersionUID = -2213669257401436260L;
    private final List<MarkToBaseMark> marksbases = new ArrayList<MarkToBaseMark>();

    public GposLookupType6(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.idx >= line.end) {
            return false;
        }
        if (this.openReader.isSkip(line.get(line.idx).getCode(), this.lookupFlag)) {
            ++line.idx;
            return false;
        }
        boolean changed = false;
        OpenTableLookup.GlyphIndexer gi = null;
        for (MarkToBaseMark mb : this.marksbases) {
            GposAnchor[] gpas;
            OtfMarkRecord omr = mb.marks.get(line.get(line.idx).getCode());
            if (omr == null) continue;
            if (gi == null) {
                gi = new OpenTableLookup.GlyphIndexer();
                gi.idx = line.idx;
                gi.line = line;
                do {
                    int prev = gi.idx;
                    boolean foundBaseGlyph = false;
                    gi.previousGlyph(this.openReader, this.lookupFlag);
                    if (gi.idx != -1) {
                        for (int i = gi.idx; i < prev; ++i) {
                            if (this.openReader.getGlyphClass(line.get(i).getCode()) != 1) continue;
                            foundBaseGlyph = true;
                            break;
                        }
                    }
                    if (!foundBaseGlyph) continue;
                    gi.glyph = null;
                    break;
                } while (gi.glyph != null && !mb.baseMarks.containsKey(gi.glyph.getCode()));
                if (gi.glyph == null) break;
            }
            if ((gpas = mb.baseMarks.get(gi.glyph.getCode())) == null) continue;
            int markClass = omr.markClass;
            GposAnchor baseAnchor = gpas[markClass];
            GposAnchor markAnchor = omr.anchor;
            line.set(line.idx, new Glyph(line.get(line.idx), -markAnchor.XCoordinate + baseAnchor.XCoordinate, -markAnchor.YCoordinate + baseAnchor.YCoordinate, 0, 0, gi.idx - line.idx));
            changed = true;
            break;
        }
        ++line.idx;
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        this.openReader.rf.readUnsignedShort();
        int markCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int baseCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int classCount = this.openReader.rf.readUnsignedShort();
        int markArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int baseArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        List<Integer> markCoverage = this.openReader.readCoverageFormat(markCoverageLocation);
        List<Integer> baseCoverage = this.openReader.readCoverageFormat(baseCoverageLocation);
        List<OtfMarkRecord> markRecords = OtfReadCommon.readMarkArray(this.openReader, markArrayLocation);
        MarkToBaseMark markToBaseMark = new MarkToBaseMark();
        for (int k = 0; k < markCoverage.size(); ++k) {
            markToBaseMark.marks.put(markCoverage.get(k), markRecords.get(k));
        }
        List<GposAnchor[]> baseArray = OtfReadCommon.readBaseArray(this.openReader, classCount, baseArrayLocation);
        for (int k = 0; k < baseCoverage.size(); ++k) {
            markToBaseMark.baseMarks.put(baseCoverage.get(k), baseArray.get(k));
        }
        this.marksbases.add(markToBaseMark);
    }

    private static class MarkToBaseMark
    implements Serializable {
        private static final long serialVersionUID = -2097614797893579206L;
        public final Map<Integer, OtfMarkRecord> marks = new HashMap<Integer, OtfMarkRecord>();
        public final Map<Integer, GposAnchor[]> baseMarks = new HashMap<Integer, GposAnchor[]>();

        private MarkToBaseMark() {
        }
    }
}

