/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SES_ESPictureInfo
extends ASN1Object
implements PKCSObjectIdentifiers {
    private DERIA5String type;
    private ASN1OctetString data;
    private ASN1Integer width;
    private ASN1Integer height;

    public static SES_ESPictureInfo getInstance(Object o) {
        if (o instanceof SES_ESPictureInfo) {
            return (SES_ESPictureInfo)((Object)o);
        }
        if (o != null) {
            return new SES_ESPictureInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_ESPictureInfo(DERIA5String type, ASN1OctetString data, ASN1Integer width, ASN1Integer height) {
        this.type = type;
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public SES_ESPictureInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.type = DERIA5String.getInstance(e.nextElement());
        this.data = ASN1OctetString.getInstance(e.nextElement());
        this.width = ASN1Integer.getInstance(e.nextElement());
        this.height = ASN1Integer.getInstance(e.nextElement());
    }

    public DERIA5String getType() {
        return this.type;
    }

    public ASN1OctetString getData() {
        return this.data;
    }

    public ASN1Integer getWidth() {
        return this.width;
    }

    public ASN1Integer getHeight() {
        return this.height;
    }

    public void setType(DERIA5String type) {
        this.type = type;
    }

    public void setData(ASN1OctetString data) {
        this.data = data;
    }

    public void setWidth(ASN1Integer width) {
        this.width = width;
    }

    public void setHeight(ASN1Integer height) {
        this.height = height;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.type);
        v.add((ASN1Encodable)this.data);
        v.add((ASN1Encodable)this.width);
        v.add((ASN1Encodable)this.height);
        return new DERSequence(v);
    }
}

