/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.format;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.system.logging.LoggerManager;
import java.security.Provider;
import java.security.Signature;

public class SM2Decide {
    private SM2Decide() {
    }

    public static boolean isSM2Type(Mechanism mechanism) {
        return mechanism != null && SM2Decide.isSM2Type(mechanism.getMechanismType());
    }

    public static boolean isSM2Type(String mType) {
        return mType != null && mType.toUpperCase().indexOf("SM2") != -1;
    }

    public static String getSignByHashName(Provider provider) {
        String signByHash = SM2Decide.findSM2SignByHashAlgorithm(provider, "SM2");
        if (signByHash == null) {
            signByHash = SM2Decide.findSM2SignByHashAlgorithm(provider, "SimuSM2");
        }
        if (signByHash == null) {
            LoggerManager.exceptionLogger.error("HardLib constructor error in GetSignature without SM2/SimuSM2 for SM2SignByHash ");
            signByHash = "SM2";
        }
        return signByHash;
    }

    private static String findSM2SignByHashAlgorithm(Provider provider, String algorithm) {
        String algorithmName = null;
        try {
            Signature.getInstance(algorithm, provider);
            algorithmName = algorithm;
        }
        catch (Exception e) {
            algorithmName = null;
        }
        return algorithmName;
    }
}

