/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.generator;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.lib.crypto.hard.format.ECCFormatKey;
import cfca.sadk.lib.crypto.hard.generator.AbsGenerator;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;

public class ECCGenerator
extends AbsGenerator {
    public ECCGenerator(Provider provider, String mType, ECCCurveId curveId) throws Exception {
        super(provider, "ECDSA", curveId);
        if (curveId == null) {
            throw new IllegalArgumentException("curveId==null");
        }
    }

    KeyPair checkKeyPairInternal(KeyPair keyPair, int keyIndex) throws Exception {
        PublicKey pubKey = ECCFormatKey.convertToProviderECCPublicKey(SADKProvider.INSTANCE(), keyPair.getPublic());
        ECCFormatKey.checkECCKey(pubKey, keyIndex, this.curveId);
        InternalPrivateKey prvkey = InternalPrivateKey.from(keyPair.getPrivate(), this.curveId, keyIndex);
        return new KeyPair(pubKey, prvkey);
    }

    KeyPair formatKeyPairExternal(KeyPair keyPair) throws Exception {
        PublicKey pubKey = ECCFormatKey.convertToProviderECCPublicKey(SADKProvider.INSTANCE(), keyPair.getPublic());
        PrivateKey prvkey = ECCFormatKey.convertToProviderECCPrivateKey(SADKProvider.INSTANCE(), keyPair.getPrivate());
        return new KeyPair(pubKey, prvkey);
    }

    public KeyPair generateKeyPairExternal(Mechanism mechanism, int keyLength) throws Exception {
        ECCCurveId curveId;
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        String curveName = mechanism.getCurveName();
        ECCCurveId eCCCurveId = curveId = curveName == null ? ECCCurveId.NIST_P256 : ECCCurveId.findECCCurveId(curveName);
        if (curveId == null) {
            throw new IllegalArgumentException("do not support curveName==" + curveName);
        }
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(this.mType, this.provider);
        switch (curveId) {
            case NIST_P256: {
                curveName = ECCCurveId.NIST_P256.getCurveName();
                break;
            }
            case NIST_P384: {
                curveName = ECCCurveId.NIST_P384.getCurveName();
                break;
            }
            case NIST_P521: {
                curveName = ECCCurveId.NIST_P521.getCurveName();
                break;
            }
            default: {
                throw new IllegalArgumentException("HardLib do not support mechanism#curveName==" + curveName);
            }
        }
        keyPairGen.initialize(new ECGenParameterSpec(curveName));
        KeyPair keypair = this.formatKeyPairExternal(keyPairGen.generateKeyPair());
        return keypair;
    }
}

