/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedAttributesUtil;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.signature.decoder.SM3DualHash;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

abstract class AbstractPKCS7Decoder {
    final SignedData signedData;
    final PKCS7SignFileParser signedFile;
    final Session session;
    final ASN1Encodable signerInfo;
    final String digestAlgorithm;
    String signTime = null;

    public AbstractPKCS7Decoder(Session session, SignedData signedData, boolean isSM2Type) throws PKIException {
        this.session = session;
        this.signedData = signedData;
        this.signedFile = null;
        this.signerInfo = this.getFirstSignerInfo(isSM2Type);
        this.digestAlgorithm = isSM2Type ? "SM3" : AbstractPKCS7Decoder.getDigestAlgorithm(this.signerInfo);
    }

    public AbstractPKCS7Decoder(Session session, PKCS7SignFileParser signedFile, boolean isSM2Type) throws PKIException {
        this.session = session;
        this.signedData = null;
        this.signedFile = signedFile;
        this.signerInfo = this.getFirstSignerInfo(isSM2Type);
        this.digestAlgorithm = isSM2Type ? "SM3" : AbstractPKCS7Decoder.getDigestAlgorithm(this.signerInfo);
    }

    public String getDigestAlgorithm() throws PKIException {
        return this.digestAlgorithm;
    }

    final boolean verifySignerInfo(byte[] sourceData, X509Cert signCert) throws PKIException {
        SignHashAlgorithm algorithm = this.getSignHashAlgorithm();
        byte[] signature = this.getSignValue();
        PublicKey pubKey = signCert.getPublicKey();
        AuthAttrVerifyResult verifyResult = this.verifyAuthAttr(algorithm.signAlg, pubKey, signature);
        boolean finalResult = false;
        if (verifyResult.noneAuthAttr) {
            byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceData, pubKey);
            finalResult = this.verifyByHash(algorithm.signAlg, sourceHash, pubKey, signature);
            if (!finalResult && this.isSM2Type() && CompatibleAlgorithm.isCompatibleSM2WithoutZ()) {
                sourceHash = this.hashData(algorithm.hashAlg, sourceData, null);
                finalResult = this.verifyByHash(algorithm.signAlg, sourceHash, pubKey, signature);
            }
        } else if (verifyResult.signValid) {
            byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceData, null);
            finalResult = this.compareHashValue(sourceHash, verifyResult);
        } else {
            finalResult = verifyResult.signValid;
        }
        return finalResult;
    }

    boolean verifySignerInfoByFile(InputStream sourceData, X509Cert signCert) throws PKIException {
        SignHashAlgorithm algorithm = this.getSignHashAlgorithm();
        byte[] signature = this.getSignValue();
        PublicKey pubKey = signCert.getPublicKey();
        AuthAttrVerifyResult verifyResult = this.verifyAuthAttr(algorithm.signAlg, pubKey, signature);
        boolean finalResult = false;
        if (verifyResult.noneAuthAttr) {
            if (this.isSM2Type()) {
                SM3DualHash.SM3DualHashResult hashResult = SM3DualHash.sm2HashFile((SM2PublicKey)pubKey, sourceData, this.session);
                finalResult = this.verifyByHash(algorithm.signAlg, hashResult, pubKey, signature);
            } else {
                byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceData, pubKey);
                finalResult = this.verifyByHash(algorithm.signAlg, sourceHash, pubKey, signature);
            }
        } else if (verifyResult.signValid) {
            byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceData, null);
            finalResult = this.compareHashValue(sourceHash, verifyResult);
        } else {
            finalResult = verifyResult.signValid;
        }
        return finalResult;
    }

    boolean verifySignerInfoByHash(byte[] sourceHash, X509Cert signCert) throws PKIException {
        SignHashAlgorithm algorithm = this.getSignHashAlgorithm();
        byte[] signature = this.getSignValue();
        PublicKey pubKey = signCert.getPublicKey();
        AuthAttrVerifyResult verifyResult = this.verifyAuthAttr(algorithm.signAlg, pubKey, signature);
        boolean finalResult = false;
        finalResult = verifyResult.noneAuthAttr ? this.verifyByHash(algorithm.signAlg, sourceHash, pubKey, signature) : (verifyResult.signValid ? this.compareHashValue(sourceHash, verifyResult) : verifyResult.signValid);
        return finalResult;
    }

    boolean verifyP7SignedFile(String sourceFileOutputPath, X509Cert signCert) throws PKIException {
        SignHashAlgorithm algorithm = this.getSignHashAlgorithm();
        byte[] signature = this.getSignValue();
        PublicKey pubKey = signCert.getPublicKey();
        AuthAttrVerifyResult verifyResult = this.verifyAuthAttr(algorithm.signAlg, pubKey, signature);
        ASN1Node sourceNode = (ASN1Node)((ASN1Node)this.signedFile.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
        if (sourceNode.childNodes.size() == 1) {
            sourceNode = (ASN1Node)sourceNode.childNodes.get(0);
        }
        boolean finalResult = false;
        if (verifyResult.noneAuthAttr) {
            if (this.isSM2Type()) {
                SM3DualHash.SM3DualHashResult dualHashResult = SM3DualHash.sm2HashFile((SM2PublicKey)pubKey, sourceNode, sourceFileOutputPath, this.session);
                finalResult = this.verifyByHash(algorithm.signAlg, dualHashResult, pubKey, signature);
            } else {
                byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceNode, null, sourceFileOutputPath);
                finalResult = this.verifyByHash(algorithm.signAlg, sourceHash, pubKey, signature);
            }
        } else if (verifyResult.signValid) {
            byte[] sourceHash = this.hashData(algorithm.hashAlg, sourceNode, null, sourceFileOutputPath);
            finalResult = this.compareHashValue(sourceHash, verifyResult);
        } else {
            finalResult = verifyResult.signValid;
        }
        return finalResult;
    }

    public final String getSignTime() throws PKIException {
        AttributeTable attributeTable;
        Attribute signTimeAttr;
        boolean hasSignTimeAttr;
        ASN1Set signedAttributeSet;
        if (this.signTime == null && (signedAttributeSet = this.getAuthenticatedAttributes()) != null && (hasSignTimeAttr = this.hasSignTime(signTimeAttr = (attributeTable = new AttributeTable(signedAttributeSet)).get(CMSAttributes.signingTime)))) {
            Time time = Time.getInstance(signTimeAttr.getAttrValues().getObjectAt(0).toASN1Primitive());
            Date signTimeDate = time.getDate();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.signTime = format.format(signTimeDate);
        }
        return this.signTime;
    }

    abstract boolean isSM2Type();

    abstract byte[] getSignValue() throws PKIException;

    abstract SignHashAlgorithm getSignHashAlgorithm() throws PKIException;

    final AuthAttrVerifyResult verifyAuthAttr(Mechanism signAlg, PublicKey pubKey, byte[] signature) throws PKIException {
        ASN1Set authAttributes = this.getAuthenticatedAttributes();
        AuthAttrVerifyResult verifyResult = null;
        if (authAttributes != null) {
            try {
                byte[] bAuthAttries = authAttributes.getEncoded();
                boolean signValid = this.session.verify(signAlg, pubKey, bAuthAttries, signature);
                byte[] hashValue = AuthenticatedAttributesUtil.getMessageDigest(authAttributes);
                verifyResult = AuthAttrVerifyResult.haveAuthAttr(hashValue, signValid);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "signAuthAttr verify failed", e);
            }
        } else {
            verifyResult = AuthAttrVerifyResult.noneAuthAttr();
        }
        return verifyResult;
    }

    final boolean dualCompareHashValue(SM3DualHash.SM3DualHashResult hashResult, AuthAttrVerifyResult verifyResult) throws PKIException {
        return this.compareHashValue(hashResult.hashValue, verifyResult) || hashResult.supportedWithoutZ && this.compareHashValue(hashResult.hashWithoutZ, verifyResult);
    }

    final boolean compareHashValue(byte[] sourceHash, AuthAttrVerifyResult verifyResult) throws PKIException {
        boolean finalResult = Arrays.equals(sourceHash, verifyResult.hashValue);
        if (!finalResult) {
            LoggerManager.exceptionLogger.error("the sourceHash is not equals with hashValue in authAttributes!");
        }
        return finalResult;
    }

    final boolean verifyByHash(Mechanism signAlg, byte[] sourceHash, PublicKey pubKey, byte[] signature) throws PKIException {
        try {
            return this.session.verifyByHash(signAlg, pubKey, sourceHash, signature);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "signature verify failed", e);
        }
    }

    private boolean verifyByHash(Mechanism signAlg, SM3DualHash.SM3DualHashResult dualHashResult, PublicKey pubKey, byte[] signature) throws PKIException {
        try {
            return this.session.verifyByHash(signAlg, pubKey, dualHashResult.hashValue, signature) || dualHashResult.supportedWithoutZ && this.session.verifyByHash(signAlg, pubKey, dualHashResult.hashWithoutZ, signature);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "signature verify failed", e);
        }
    }

    abstract byte[] hashData(String var1, byte[] var2, PublicKey var3) throws PKIException;

    abstract byte[] hashData(String var1, InputStream var2, PublicKey var3) throws PKIException;

    abstract byte[] hashData(String var1, ASN1Node var2, PublicKey var3, String var4) throws PKIException;

    private final boolean hasSignTime(Attribute signTimeAttr) {
        boolean hasSignTime = false;
        if (signTimeAttr != null) {
            hasSignTime = signTimeAttr.getAttrValues() != null && signTimeAttr.getAttrValues().size() > 0;
        }
        return hasSignTime;
    }

    private final ASN1Encodable getFirstSignerInfo(boolean isSM2Type) throws PKIException {
        ASN1Encodable signerInfoResult = null;
        if (this.signerInfo == null) {
            if (this.signedData == null && this.signedFile == null) {
                throw new PKIException("can not get SignerInfo object: signedData/signedFile==null");
            }
            ASN1Set signerInfos = null;
            if (this.signedData != null) {
                signerInfos = this.signedData.getSignerInfos();
            } else {
                try {
                    ASN1Node singerinfo_node = this.signedFile.getSingerinfo_node();
                    signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
                }
                catch (Exception e) {
                    throw new PKIException("signedFile get signerInfo object failed", e);
                }
            }
            if (signerInfos.size() == 0) {
                throw new PKIException("can not get SignerInfo object: signerInfos==0");
            }
            ASN1Encodable signer = signerInfos.getObjectAt(0);
            signerInfoResult = isSM2Type ? SM2SignerInfo.getInstance(signer) : SignerInfo.getInstance(signer);
        } else {
            signerInfoResult = this.signerInfo;
        }
        return signerInfoResult;
    }

    private final ASN1Set getAuthenticatedAttributes() throws PKIException {
        ASN1Encodable signerInfo = this.getFirstSignerInfo(this.isSM2Type());
        ASN1Set signedAttributeSet = null;
        if (signerInfo instanceof SignerInfo) {
            signedAttributeSet = ((SignerInfo)signerInfo).getAuthenticatedAttributes();
        } else if (signerInfo instanceof SM2SignerInfo) {
            signedAttributeSet = ((SM2SignerInfo)signerInfo).getAuthenticatedAttributes();
        } else {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, "signedAttribute invalid");
        }
        return signedAttributeSet;
    }

    public static String getDigestAlgorithm(ASN1Encodable signerInfo) throws PKIException {
        ASN1ObjectIdentifier digestId = SignerInfo.getInstance(signerInfo).getDigestAlgorithm().getAlgorithm();
        String digestAlgorithm = Mechanisms.getDigestAlgorithmName(digestId);
        if (digestAlgorithm == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support digestId=" + digestId);
        }
        return digestAlgorithm;
    }

    static final class SignHashAlgorithm {
        final Mechanism signAlg;
        final String hashAlg;

        SignHashAlgorithm(Mechanism signAlg, String hashAlg) {
            this.signAlg = signAlg;
            this.hashAlg = hashAlg;
        }
    }

    static final class AuthAttrVerifyResult {
        final byte[] hashValue;
        final boolean noneAuthAttr;
        final boolean signValid;

        AuthAttrVerifyResult(byte[] hashValue, boolean noneAuthAttr, boolean signValid) {
            this.hashValue = hashValue;
            this.noneAuthAttr = noneAuthAttr;
            this.signValid = signValid;
        }

        static AuthAttrVerifyResult haveAuthAttr(byte[] hashValue, boolean signValid) {
            return new AuthAttrVerifyResult(hashValue, false, signValid);
        }

        static AuthAttrVerifyResult noneAuthAttr() {
            return new AuthAttrVerifyResult(null, true, false);
        }
    }
}

