/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss;

import com.obs.services.ObsClient;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class HuaweiObsTemplate
implements OssTemplate {
    private final ObsClient obsClient;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.obsClient.createBucket(this.getBucketName(bucketName));
        }
    }

    @Override
    public void removeBucket(String bucketName) {
        this.obsClient.deleteBucket(this.getBucketName(bucketName));
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.obsClient.headBucket(this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.obsClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.obsClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.obsClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMd5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getOssHost(this.getBucketName()).concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    @Override
    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    @Override
    public void removeFile(String fileName) {
        this.obsClient.deleteObject(this.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.obsClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    @Override
    public InputStream statFileStream(String fileName) {
        return this.statFileStream(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public InputStream statFileStream(String bucketName, String fileName) {
        ObsObject object = this.obsClient.getObject(this.getBucketName(bucketName), fileName);
        return object.getObjectContent();
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
        } else {
            PutObjectResult response = this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getEtag()) && retry < retryCount; ++retry) {
                response = this.obsClient.putObject(this.getBucketName(bucketName), key, stream);
            }
        }
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setLink(this.fileLink(bucketName, key));
        return file;
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public HuaweiObsTemplate(ObsClient obsClient, OssProperties ossProperties, OssRule ossRule) {
        this.obsClient = obsClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

