/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.renderer;

import cfca.sadk.com.itextpdf.kernel.geom.PageSize;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.element.AreaBreak;
import cfca.sadk.com.itextpdf.layout.layout.LayoutArea;
import cfca.sadk.com.itextpdf.layout.layout.LayoutResult;
import cfca.sadk.com.itextpdf.layout.property.AreaBreakType;
import cfca.sadk.com.itextpdf.layout.renderer.DrawContext;
import cfca.sadk.com.itextpdf.layout.renderer.FloatingHelper;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.RootRenderer;
import java.util.ArrayList;
import java.util.List;

public class DocumentRenderer
extends RootRenderer {
    protected Document document;
    protected List<Integer> wrappedContentPage = new ArrayList<Integer>();

    public DocumentRenderer(Document document) {
        this(document, true);
    }

    public DocumentRenderer(Document document, boolean immediateFlush) {
        this.document = document;
        this.immediateFlush = immediateFlush;
        this.modelElement = document;
    }

    @Override
    public LayoutArea getOccupiedArea() {
        throw new IllegalStateException("Not applicable for DocumentRenderer");
    }

    @Override
    public IRenderer getNextRenderer() {
        return new DocumentRenderer(this.document, this.immediateFlush);
    }

    @Override
    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        PageSize customPageSize;
        AreaBreak areaBreak;
        this.flushWaitingDrawingElements();
        AreaBreak areaBreak2 = areaBreak = overflowResult != null && overflowResult.getAreaBreak() != null ? overflowResult.getAreaBreak() : null;
        if (areaBreak != null && areaBreak.getType() == AreaBreakType.LAST_PAGE) {
            while (this.currentPageNumber < this.document.getPdfDocument().getNumberOfPages()) {
                this.moveToNextPage();
            }
        } else {
            this.moveToNextPage();
        }
        PageSize pageSize = customPageSize = areaBreak != null ? areaBreak.getPageSize() : null;
        while (this.document.getPdfDocument().getNumberOfPages() >= this.currentPageNumber && this.document.getPdfDocument().getPage(this.currentPageNumber).isFlushed()) {
            ++this.currentPageNumber;
        }
        PageSize lastPageSize = this.ensureDocumentHasNPages(this.currentPageNumber, customPageSize);
        if (lastPageSize == null) {
            lastPageSize = new PageSize(this.document.getPdfDocument().getPage(this.currentPageNumber).getTrimBox());
        }
        this.currentArea = new LayoutArea(this.currentPageNumber, this.document.getPageEffectiveArea(lastPageSize));
        return this.currentArea;
    }

    @Override
    protected void flushSingleRenderer(IRenderer resultRenderer) {
        if (!this.waitingDrawingElements.contains(resultRenderer) && (FloatingHelper.isRendererFloating(resultRenderer) || resultRenderer.getProperty(106) != null)) {
            this.waitingDrawingElements.add(resultRenderer);
            return;
        }
        if (!resultRenderer.isFlushed()) {
            boolean isModified;
            int streamCount;
            int pageNum = resultRenderer.getOccupiedArea().getPageNumber();
            PdfDocument pdfDocument = this.document.getPdfDocument();
            this.ensureDocumentHasNPages(pageNum, null);
            PdfPage correspondingPage = pdfDocument.getPage(pageNum);
            boolean wrapOldContent = pdfDocument.getReader() != null && pdfDocument.getWriter() != null && correspondingPage.getContentStreamCount() > 0 && correspondingPage.getLastContentStream().getLength() > 0 && !this.wrappedContentPage.contains(pageNum) && pdfDocument.getNumberOfPages() >= pageNum;
            this.wrappedContentPage.add(pageNum);
            if (pdfDocument.isTagged()) {
                pdfDocument.getTagStructureContext().getAutoTaggingPointer().setPageForTagging(correspondingPage);
            }
            PdfStream modifiedStream = null;
            int index = streamCount = correspondingPage.getContentStreamCount();
            while (!(isModified = (modifiedStream = correspondingPage.getContentStream(--index)).isModified()) && index > 0) {
            }
            PdfCanvas pdfCanvas = new PdfCanvas(modifiedStream, correspondingPage.getResources(), pdfDocument);
            resultRenderer.draw(new DrawContext(pdfDocument, pdfCanvas, pdfDocument.isTagged()));
        }
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        if (customPageSize != null) {
            this.document.getPdfDocument().addNewPage(customPageSize);
        } else {
            this.document.getPdfDocument().addNewPage();
        }
        return customPageSize != null ? customPageSize : this.document.getPdfDocument().getDefaultPageSize();
    }

    private PageSize ensureDocumentHasNPages(int n, PageSize customPageSize) {
        PageSize lastPageSize = null;
        while (this.document.getPdfDocument().getNumberOfPages() < n) {
            lastPageSize = this.addNewPage(customPageSize);
        }
        return lastPageSize;
    }

    private void moveToNextPage() {
        if (this.immediateFlush && this.currentPageNumber > 1) {
            this.document.getPdfDocument().getPage(this.currentPageNumber - 1).flush();
        }
        ++this.currentPageNumber;
    }
}

