/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.signer;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import cfca.sadk.lib.crypto.hard.signer.ECCSigner;
import cfca.sadk.lib.crypto.hard.signer.RSASigner;
import cfca.sadk.lib.crypto.hard.signer.SM2Signer;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;

public abstract class AbsSigner {
    private static final int BUFFSIZE = 16384;
    final Provider provider;
    final String mType;
    final boolean asn1Format;
    final Signature signature;
    int eccByteLength = 0;

    protected AbsSigner(Provider provider, String mType, boolean asn1Format) throws Exception {
        this.provider = provider;
        this.mType = mType;
        this.asn1Format = asn1Format;
        this.signature = Signature.getInstance(mType, provider);
    }

    public final void initSign(PrivateKey privateKey) throws Exception {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey == null;");
        }
        PrivateKey jceKey = null;
        jceKey = privateKey instanceof InternalPrivateKey ? ((InternalPrivateKey)privateKey).getInternalPrivateKey() : this.formatPrivateKey(privateKey);
        this.signature.initSign(jceKey);
        this.eccByteLength = this.setEccLength(jceKey);
    }

    public final void initVerify(PublicKey publicKey) throws Exception {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey = null;");
        }
        this.signature.initVerify(this.formatPublicKey(publicKey));
    }

    public final void update(byte[] data) throws Exception {
        if (data != null && data.length != 0) {
            this.signature.update(data);
        }
    }

    public final void update(InputStream sourceStream) throws Exception {
        if (sourceStream != null) {
            byte[] buffer = new byte[16384];
            int readLength = 0;
            BufferedInputStream sourceData = new BufferedInputStream(sourceStream);
            while ((readLength = sourceData.read(buffer)) > 0) {
                this.signature.update(buffer, 0, readLength);
            }
        }
    }

    public final byte[] sign() throws Exception {
        return this.formatOutputSignValue(this.signature.sign());
    }

    public final boolean verify(byte[] signData) throws Exception {
        return this.signature.verify(this.formatInputSignValue(signData));
    }

    public abstract int setEccLength(PrivateKey var1) throws Exception;

    public abstract byte[] signByHash(PrivateKey var1, byte[] var2) throws Exception;

    public abstract boolean verifyByHash(PublicKey var1, byte[] var2, byte[] var3) throws Exception;

    abstract PrivateKey formatPrivateKey(PrivateKey var1) throws Exception;

    abstract PublicKey formatPublicKey(PublicKey var1) throws Exception;

    abstract byte[] formatInputSignValue(byte[] var1) throws Exception;

    abstract byte[] formatOutputSignValue(byte[] var1) throws Exception;

    public static AbsSigner createSigner(Provider provider, Mechanism mechanism, boolean asn1Format) throws Exception {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        String mType = mechanism.getMechanismType();
        if (mType == null) {
            throw new IllegalArgumentException("mType==null");
        }
        mType = mType.toUpperCase();
        AbsSigner signer = null;
        if (mType.contains("SM2")) {
            signer = new SM2Signer(provider, mType, asn1Format);
        } else if (mType.contains("RSA")) {
            signer = new RSASigner(provider, mType, asn1Format);
        } else if (mType.contains("EC")) {
            signer = new ECCSigner(provider, mType, asn1Format);
        } else {
            throw new IllegalArgumentException("do not support mType==" + mType);
        }
        return signer;
    }
}

