/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.bean.crl;

import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.x509.CertificateList;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.x509.certificate.X509CRL;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class X509CRLMap {
    private Map<String, Date> crlMap = new ConcurrentHashMap<String, Date>();

    public X509CRLMap(X509CRL x509crl) throws SealException {
        this.updateCRL(x509crl);
    }

    public void updateCRL(X509CRL x509crl) throws SealException {
        CertificateList list = x509crl.getCertificateList();
        TBSCertList.CRLEntry[] certList = list.getRevokedCertificates();
        if (certList.length > SysEnv.getMaxCRLRecode()) {
            throw new SealException("crl recode is more than " + SysEnv.getMaxCRLRecode());
        }
        for (TBSCertList.CRLEntry crlEntry : certList) {
            BigInteger bigIntSN = crlEntry.getUserCertificate().getPositiveValue();
            Date revokeDate = crlEntry.getRevocationDate().getDate();
            this.crlMap.put(bigIntSN.toString(16), revokeDate);
        }
    }

    public boolean isRevoked(String sn, Date signDate) {
        boolean isRevoked = false;
        Date revokedDate = this.crlMap.get(sn);
        if (null != revokedDate && signDate.after(revokedDate)) {
            isRevoked = true;
        }
        return isRevoked;
    }
}

